/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.migration;

import io.ebean.migration.DbNameUtil;
import io.ebean.migration.MigrationConfig;
import io.ebean.migration.MigrationException;
import io.ebean.migration.runner.LocalMigrationResource;
import io.ebean.migration.runner.LocalMigrationResources;
import io.ebean.migration.runner.MigrationSchema;
import io.ebean.migration.runner.MigrationTable;
import io.ebean.migration.util.JdbcClose;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationRunner {
    private static final Logger logger = LoggerFactory.getLogger(MigrationRunner.class);
    private final MigrationConfig migrationConfig;
    private List<LocalMigrationResource> checkMigrations;

    public MigrationRunner(MigrationConfig migrationConfig) {
        this.migrationConfig = migrationConfig;
    }

    public void run() {
        this.run(this.migrationConfig.createConnection());
    }

    public List<LocalMigrationResource> checkState() {
        this.run(this.migrationConfig.createConnection(), true);
        return this.checkMigrations;
    }

    public List<LocalMigrationResource> checkState(DataSource dataSource) {
        this.run(this.getConnection(dataSource), true);
        return this.checkMigrations;
    }

    public List<LocalMigrationResource> checkState(Connection connection) {
        this.run(connection, true);
        return this.checkMigrations;
    }

    public void run(DataSource dataSource) {
        this.run(this.getConnection(dataSource));
    }

    private Connection getConnection(DataSource dataSource) {
        String username = this.migrationConfig.getDbUsername();
        try {
            if (username == null) {
                return dataSource.getConnection();
            }
            logger.debug("using db user [{}] to run migrations ...", (Object)username);
            return dataSource.getConnection(username, this.migrationConfig.getDbPassword());
        }
        catch (SQLException e) {
            String msgSuffix = username == null ? "" : " using user [" + username + "]";
            throw new IllegalArgumentException("Error trying to connect to database for DB Migration" + msgSuffix, e);
        }
    }

    public void run(Connection connection) {
        this.run(connection, false);
    }

    public void run(Connection connection, boolean checkStateMode) {
        LocalMigrationResources resources = new LocalMigrationResources(this.migrationConfig);
        if (!resources.readResources()) {
            logger.debug("no migrations to check");
            return;
        }
        try {
            connection.setAutoCommit(false);
            MigrationSchema schema = new MigrationSchema(this.migrationConfig, connection);
            schema.createAndSetIfNeeded();
            this.runMigrations(resources, connection, checkStateMode);
            connection.commit();
        }
        catch (MigrationException e) {
            JdbcClose.rollback(connection);
            throw e;
        }
        catch (Exception e) {
            JdbcClose.rollback(connection);
            throw new RuntimeException(e);
        }
        finally {
            JdbcClose.close(connection);
        }
    }

    private void runMigrations(LocalMigrationResources resources, Connection connection, boolean checkStateMode) throws SQLException, IOException {
        this.derivePlatformName(this.migrationConfig, connection);
        MigrationTable table = new MigrationTable(this.migrationConfig, connection, checkStateMode);
        table.createIfNeededAndLock();
        List<LocalMigrationResource> localVersions = resources.getVersions();
        logger.info("local migrations:{}  existing migrations:{}  checkState:{}", new Object[]{localVersions.size(), table.size(), checkStateMode});
        LocalMigrationResource priorVersion = null;
        for (LocalMigrationResource localVersion : localVersions) {
            if (!table.shouldRun(localVersion, priorVersion)) break;
            priorVersion = localVersion;
        }
        if (checkStateMode) {
            this.checkMigrations = table.ran();
        }
    }

    private void derivePlatformName(MigrationConfig migrationConfig, Connection connection) {
        if (migrationConfig.getPlatformName() == null) {
            migrationConfig.setPlatformName(DbNameUtil.normalise(connection));
        }
    }
}

