/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.migration.runner;

import io.ebean.migration.MigrationVersion;

public abstract class LocalMigrationResource
implements Comparable<LocalMigrationResource> {
    protected final MigrationVersion version;
    protected final String location;

    public LocalMigrationResource(MigrationVersion version, String location) {
        this.version = version;
        this.location = location;
    }

    public String toString() {
        return this.version.toString();
    }

    public boolean isRepeatable() {
        return this.version.isRepeatable();
    }

    public String key() {
        if (this.isRepeatable()) {
            return this.version.getComment().toLowerCase();
        }
        return this.version.normalised();
    }

    public String getComment() {
        String comment = this.version.getComment();
        return comment == null || comment.isEmpty() ? "-" : comment;
    }

    @Override
    public int compareTo(LocalMigrationResource o) {
        return this.version.compareTo(o.version);
    }

    public MigrationVersion getVersion() {
        return this.version;
    }

    public String getLocation() {
        return this.location;
    }

    public abstract String getContent();

    public String getType() {
        return this.version.getType();
    }
}

