/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.migration.runner;

import io.ebean.migration.MigrationConfig;
import io.ebean.migration.MigrationException;
import io.ebean.migration.runner.Checksum;
import io.ebean.migration.runner.LocalDdlMigrationResource;
import io.ebean.migration.runner.LocalJdbcMigrationResource;
import io.ebean.migration.runner.LocalMigrationResource;
import io.ebean.migration.runner.MigrationMetaRow;
import io.ebean.migration.runner.MigrationScriptRunner;
import io.ebean.migration.runner.PlaceholderBuilder;
import io.ebean.migration.runner.ScriptTransform;
import io.ebean.migration.util.IOUtils;
import io.ebean.migration.util.JdbcClose;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationTable {
    private static final Logger logger = LoggerFactory.getLogger(MigrationTable.class);
    private final Connection connection;
    private final boolean checkState;
    private final String catalog;
    private final String schema;
    private final String table;
    private final String sqlTable;
    private final String envUserName;
    private final String platformName;
    private final Timestamp runOn = new Timestamp(System.currentTimeMillis());
    private final ScriptTransform scriptTransform;
    private final String insertSql;
    private final String updateSql;
    private final String updateChecksumSql;
    private final String selectSql;
    private final LinkedHashMap<String, MigrationMetaRow> migrations;
    private final boolean skipChecksum;
    private final Set<String> patchInsertVersions;
    private final Set<String> patchResetChecksumVersions;
    private MigrationMetaRow lastMigration;
    private final List<LocalMigrationResource> checkMigrations = new ArrayList<LocalMigrationResource>();

    public MigrationTable(MigrationConfig config, Connection connection, boolean checkState) {
        this.connection = connection;
        this.checkState = checkState;
        this.migrations = new LinkedHashMap();
        this.catalog = null;
        this.patchResetChecksumVersions = config.getPatchResetChecksumOn();
        this.patchInsertVersions = config.getPatchInsertOn();
        this.skipChecksum = config.isSkipChecksum();
        this.schema = config.getDbSchema();
        this.table = config.getMetaTable();
        this.platformName = config.getPlatformName();
        this.sqlTable = this.sqlTable();
        this.selectSql = MigrationMetaRow.selectSql(this.sqlTable, this.platformName);
        this.insertSql = MigrationMetaRow.insertSql(this.sqlTable);
        this.updateSql = MigrationMetaRow.updateSql(this.sqlTable);
        this.updateChecksumSql = MigrationMetaRow.updateChecksumSql(this.sqlTable);
        this.scriptTransform = this.createScriptTransform(config);
        this.envUserName = System.getProperty("user.name");
    }

    public List<LocalMigrationResource> ran() {
        return this.checkMigrations;
    }

    private String sqlTable() {
        if (this.schema != null) {
            return this.schema + "." + this.table;
        }
        return this.table;
    }

    private String sqlPrimaryKey() {
        return "pk_" + this.table;
    }

    public int size() {
        return this.migrations.size();
    }

    private ScriptTransform createScriptTransform(MigrationConfig config) {
        Map<String, String> map = PlaceholderBuilder.build(config.getRunPlaceholders(), config.getRunPlaceholderMap());
        return new ScriptTransform(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createIfNeededAndLock() throws SQLException, IOException {
        if (!this.tableExists(this.connection)) {
            this.createTable(this.connection);
        }
        PreparedStatement query = this.connection.prepareStatement(this.selectSql);
        try {
            ResultSet resultSet = query.executeQuery();
            try {
                while (resultSet.next()) {
                    MigrationMetaRow metaRow = new MigrationMetaRow(resultSet);
                    this.addMigration(metaRow.getVersion(), metaRow);
                }
            }
            finally {
                JdbcClose.close(resultSet);
            }
        }
        finally {
            JdbcClose.close(query);
        }
    }

    private void createTable(Connection connection) throws IOException, SQLException {
        String tableScript = this.createTableDdl();
        MigrationScriptRunner run = new MigrationScriptRunner(connection);
        run.runScript(false, tableScript, "create migration table");
    }

    String createTableDdl() throws IOException {
        String script = ScriptTransform.replace("${table}", this.sqlTable, this.getCreateTableScript());
        return ScriptTransform.replace("${pk_table}", this.sqlPrimaryKey(), script);
    }

    private String getCreateTableScript() throws IOException {
        String script = this.readResource("migration-support/create-table.sql");
        if (script == null && this.platformName != null && !this.platformName.isEmpty()) {
            script = this.readResource("migration-support/" + this.platformName + "-create-table.sql");
        }
        if (script == null) {
            script = this.readResource("migration-support/default-create-table.sql");
        }
        return script;
    }

    private String readResource(String location) throws IOException {
        Enumeration<URL> resources = this.getClassLoader().getResources(location);
        if (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            return IOUtils.readUtf8(url.openStream());
        }
        return null;
    }

    private ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tableExists(Connection connection) throws SQLException {
        String migTable = this.table;
        DatabaseMetaData metaData = connection.getMetaData();
        if (metaData.storesUpperCaseIdentifiers()) {
            migTable = migTable.toUpperCase();
        }
        String checkCatalog = this.catalog != null ? this.catalog : connection.getCatalog();
        String checkSchema = this.schema != null ? this.schema : connection.getSchema();
        ResultSet tables = metaData.getTables(checkCatalog, checkSchema, migTable, null);
        try {
            boolean bl = tables.next();
            return bl;
        }
        finally {
            JdbcClose.close(tables);
        }
    }

    public boolean shouldRun(LocalMigrationResource localVersion, LocalMigrationResource priorVersion) throws SQLException {
        if (priorVersion != null && !localVersion.isRepeatable() && !this.migrationExists(priorVersion)) {
            logger.error("Migration {} requires prior migration {} which has not been run", (Object)localVersion.getVersion(), (Object)priorVersion.getVersion());
            return false;
        }
        MigrationMetaRow existing = this.migrations.get(localVersion.key());
        return this.runMigration(localVersion, existing);
    }

    private boolean runMigration(LocalMigrationResource local, MigrationMetaRow existing) throws SQLException {
        int checksum;
        String script = null;
        if (local instanceof LocalDdlMigrationResource) {
            script = this.convertScript(((LocalDdlMigrationResource)local).getContent());
            checksum = Checksum.calculate(script);
        } else {
            checksum = ((LocalJdbcMigrationResource)local).getChecksum();
        }
        if (existing == null && this.patchInsertMigration(local, checksum)) {
            return true;
        }
        if (existing != null && this.skipMigration(checksum, local, existing)) {
            return true;
        }
        this.executeMigration(local, script, checksum, existing);
        return true;
    }

    private boolean patchInsertMigration(LocalMigrationResource local, int checksum) throws SQLException {
        if (this.patchInsertVersions != null && this.patchInsertVersions.contains(local.key())) {
            logger.info("patch migration - insert into history {}", (Object)local.getLocation());
            if (!this.checkState) {
                this.insertIntoHistory(local, checksum, 0L);
            }
            return true;
        }
        return false;
    }

    boolean skipMigration(int checksum, LocalMigrationResource local, MigrationMetaRow existing) throws SQLException {
        boolean matchChecksum;
        boolean bl = matchChecksum = existing.getChecksum() == checksum;
        if (matchChecksum) {
            logger.trace("... skip unchanged migration {}", (Object)local.getLocation());
            return true;
        }
        if (this.patchResetChecksum(existing, checksum)) {
            logger.info("patch migration - reset checksum on {}", (Object)local.getLocation());
            return true;
        }
        if (local.isRepeatable() || this.skipChecksum) {
            return false;
        }
        throw new MigrationException("Checksum mismatch on migration " + local.getLocation());
    }

    private boolean patchResetChecksum(MigrationMetaRow existing, int newChecksum) throws SQLException {
        if (this.isResetOnVersion(existing.getVersion())) {
            if (!this.checkState) {
                existing.resetChecksum(newChecksum, this.connection, this.updateChecksumSql);
            }
            return true;
        }
        return false;
    }

    private boolean isResetOnVersion(String version) {
        return this.patchResetChecksumVersions != null && this.patchResetChecksumVersions.contains(version);
    }

    private void executeMigration(LocalMigrationResource local, String script, int checksum, MigrationMetaRow existing) throws SQLException {
        if (this.checkState) {
            this.checkMigrations.add(local);
            this.addMigration(local.key(), this.createMetaRow(local, checksum, 1L));
            return;
        }
        logger.debug("run migration {}", (Object)local.getLocation());
        long start = System.currentTimeMillis();
        if (local instanceof LocalDdlMigrationResource) {
            MigrationScriptRunner run = new MigrationScriptRunner(this.connection);
            run.runScript(false, script, "run migration version: " + local.getVersion());
        } else {
            ((LocalJdbcMigrationResource)local).getMigration().migrate(this.connection);
        }
        long exeMillis = System.currentTimeMillis() - start;
        if (existing != null) {
            existing.rerun(checksum, exeMillis, this.envUserName, this.runOn);
            existing.executeUpdate(this.connection, this.updateSql);
        } else {
            this.insertIntoHistory(local, checksum, exeMillis);
        }
    }

    private void insertIntoHistory(LocalMigrationResource local, int checksum, long exeMillis) throws SQLException {
        MigrationMetaRow metaRow = this.createMetaRow(local, checksum, exeMillis);
        metaRow.executeInsert(this.connection, this.insertSql);
        this.addMigration(local.key(), metaRow);
    }

    private MigrationMetaRow createMetaRow(LocalMigrationResource migration, int checksum, long exeMillis) {
        int nextId = 1;
        if (this.lastMigration != null) {
            nextId = this.lastMigration.getId() + 1;
        }
        String type = migration.getType();
        String runVersion = migration.key();
        String comment = migration.getComment();
        return new MigrationMetaRow(nextId, type, runVersion, comment, checksum, this.envUserName, this.runOn, exeMillis);
    }

    private boolean migrationExists(LocalMigrationResource priorVersion) {
        return this.migrations.containsKey(priorVersion.key());
    }

    private String convertScript(String script) {
        return this.scriptTransform.transform(script);
    }

    private void addMigration(String key, MigrationMetaRow metaRow) {
        this.lastMigration = metaRow;
        if (metaRow.getVersion() == null) {
            throw new IllegalStateException("No runVersion in db migration table row? " + metaRow);
        }
        this.migrations.put(key, metaRow);
    }
}

