/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.migration.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class IOUtils {
    public static String readUtf8(InputStream in) throws IOException {
        return IOUtils.bytesToUtf8(IOUtils.read(in));
    }

    private static byte[] read(InputStream in) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        IOUtils.pump(in, buffer);
        return buffer.toByteArray();
    }

    private static String bytesToUtf8(byte[] data) {
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Support for UTF-8 is mandated by the Java spec", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void pump(InputStream in, OutputStream out) throws IOException {
        if (in == null) {
            throw new IOException("Input stream is null");
        }
        if (out == null) {
            throw new IOException("Output stream is null");
        }
        try {
            try {
                int bytes;
                byte[] buffer = new byte[4096];
                while ((bytes = in.read(buffer)) >= 0) {
                    out.write(buffer, 0, bytes);
                }
            }
            finally {
                in.close();
            }
        }
        finally {
            out.close();
        }
    }
}

