/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.migration.runner;

import io.ebean.migration.JdbcMigration;
import io.ebean.migration.MigrationConfig;
import io.ebean.migration.MigrationException;
import io.ebean.migration.MigrationVersion;
import io.ebean.migration.runner.Checksum;
import io.ebean.migration.runner.LocalDdlMigrationResource;
import io.ebean.migration.runner.LocalJdbcMigrationResource;
import io.ebean.migration.runner.LocalMigrationResource;
import io.ebean.migration.runner.MigrationMetaRow;
import io.ebean.migration.runner.MigrationPlatform;
import io.ebean.migration.runner.MigrationScriptRunner;
import io.ebean.migration.runner.ScriptTransform;
import io.ebean.migration.util.IOUtils;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationTable {
    private static final Logger logger = LoggerFactory.getLogger((String)"io.ebean.DDL");
    private static final String INIT_VER_0 = "0";
    private final Connection connection;
    private final boolean checkState;
    private final MigrationPlatform platform;
    private final MigrationScriptRunner scriptRunner;
    private final String catalog;
    private final String schema;
    private final String table;
    private final String sqlTable;
    private final String envUserName;
    private final String platformName;
    private final Timestamp runOn = new Timestamp(System.currentTimeMillis());
    private final ScriptTransform scriptTransform;
    private final String insertSql;
    private final String updateSql;
    private final String updateChecksumSql;
    private final LinkedHashMap<String, MigrationMetaRow> migrations;
    private final boolean skipChecksum;
    private final Set<String> patchInsertVersions;
    private final Set<String> patchResetChecksumVersions;
    private final boolean allowErrorInRepeatable;
    private final MigrationVersion minVersion;
    private final String minVersionFailMessage;
    private MigrationVersion currentVersion;
    private MigrationMetaRow lastMigration;
    private LocalMigrationResource priorVersion;
    private final List<LocalMigrationResource> checkMigrations = new ArrayList<LocalMigrationResource>();
    private MigrationVersion dbInitVersion;

    public MigrationTable(MigrationConfig config, Connection connection, boolean checkState, MigrationPlatform platform) {
        this.platform = platform;
        this.connection = connection;
        this.scriptRunner = new MigrationScriptRunner(connection, platform);
        this.checkState = checkState;
        this.migrations = new LinkedHashMap();
        this.catalog = null;
        this.allowErrorInRepeatable = config.isAllowErrorInRepeatable();
        this.patchResetChecksumVersions = config.getPatchResetChecksumOn();
        this.patchInsertVersions = config.getPatchInsertOn();
        this.minVersion = this.initMinVersion(config.getMinVersion());
        this.minVersionFailMessage = config.getMinVersionFailMessage();
        this.skipChecksum = config.isSkipChecksum();
        this.schema = config.getDbSchema();
        this.table = config.getMetaTable();
        this.platformName = config.getPlatformName();
        this.sqlTable = this.initSqlTable();
        this.insertSql = MigrationMetaRow.insertSql(this.sqlTable);
        this.updateSql = MigrationMetaRow.updateSql(this.sqlTable);
        this.updateChecksumSql = MigrationMetaRow.updateChecksumSql(this.sqlTable);
        this.scriptTransform = this.createScriptTransform(config);
        this.envUserName = System.getProperty("user.name");
    }

    private MigrationVersion initMinVersion(String minVersion) {
        return minVersion == null || minVersion.isEmpty() ? null : MigrationVersion.parse(minVersion);
    }

    private String initSqlTable() {
        if (this.schema != null) {
            return this.schema + "." + this.table;
        }
        return this.table;
    }

    private String sqlPrimaryKey() {
        return "pk_" + this.table;
    }

    public int size() {
        return this.migrations.size();
    }

    public Set<String> getVersions() {
        return this.migrations.keySet();
    }

    private ScriptTransform createScriptTransform(MigrationConfig config) {
        return ScriptTransform.build(config.getRunPlaceholders(), config.getRunPlaceholderMap());
    }

    public void createIfNeededAndLock() throws SQLException, IOException {
        if (!this.tableExists()) {
            this.createTable();
        }
        this.obtainLockWithWait();
        this.readExistingMigrations();
    }

    private void obtainLockWithWait() throws SQLException {
        this.platform.lockMigrationTable(this.sqlTable, this.connection);
    }

    private void readExistingMigrations() throws SQLException {
        for (MigrationMetaRow metaRow : this.platform.readExistingMigrations(this.sqlTable, this.connection)) {
            this.addMigration(metaRow.getVersion(), metaRow);
        }
    }

    private void createTable() throws IOException, SQLException {
        this.scriptRunner.runScript(this.createTableDdl(), "create migration table");
        this.createInitMetaRow().executeInsert(this.connection, this.insertSql);
    }

    String createTableDdl() throws IOException {
        String script = ScriptTransform.replace("${table}", this.sqlTable, this.getCreateTableScript());
        return ScriptTransform.replace("${pk_table}", this.sqlPrimaryKey(), script);
    }

    private String getCreateTableScript() throws IOException {
        String script = this.readResource("migration-support/create-table.sql");
        if (script == null && this.platformName != null && !this.platformName.isEmpty()) {
            script = this.readResource("migration-support/" + this.platformName + "-create-table.sql");
        }
        if (script == null) {
            script = this.readResource("migration-support/default-create-table.sql");
        }
        return script;
    }

    private String readResource(String location) throws IOException {
        Enumeration<URL> resources = this.getClassLoader().getResources(location);
        if (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            return IOUtils.readUtf8(url);
        }
        return null;
    }

    private ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private boolean tableExists() throws SQLException {
        String migTable = this.table;
        DatabaseMetaData metaData = this.connection.getMetaData();
        if (metaData.storesUpperCaseIdentifiers()) {
            migTable = migTable.toUpperCase();
        }
        String checkCatalog = this.catalog != null ? this.catalog : this.connection.getCatalog();
        String checkSchema = this.schema != null ? this.schema : this.connection.getSchema();
        try (ResultSet tables = metaData.getTables(checkCatalog, checkSchema, migTable, null);){
            boolean bl = tables.next();
            return bl;
        }
    }

    private boolean shouldRun(LocalMigrationResource localVersion, LocalMigrationResource prior) throws SQLException {
        if (prior != null && !localVersion.isRepeatable() && !this.migrationExists(prior)) {
            logger.error("Migration {} requires prior migration {} which has not been run", (Object)localVersion.getVersion(), (Object)prior.getVersion());
            return false;
        }
        MigrationMetaRow existing = this.migrations.get(localVersion.key());
        if (!this.runMigration(localVersion, existing)) {
            return false;
        }
        this.priorVersion = localVersion;
        return true;
    }

    private boolean runMigration(LocalMigrationResource local, MigrationMetaRow existing) throws SQLException {
        int checksum;
        String script = null;
        if (local instanceof LocalDdlMigrationResource) {
            script = this.convertScript(local.getContent());
            checksum = Checksum.calculate(script);
        } else {
            checksum = ((LocalJdbcMigrationResource)local).getChecksum();
        }
        if (existing == null && this.patchInsertMigration(local, checksum)) {
            return true;
        }
        if (existing != null && this.skipMigration(checksum, local, existing)) {
            return true;
        }
        this.executeMigration(local, script, checksum, existing);
        return true;
    }

    private boolean patchInsertMigration(LocalMigrationResource local, int checksum) throws SQLException {
        if (this.patchInsertVersions != null && this.patchInsertVersions.contains(local.key())) {
            logger.info("patch migration - insert into history {}", (Object)local.getLocation());
            if (!this.checkState) {
                this.insertIntoHistory(local, checksum, 0L);
            }
            return true;
        }
        return false;
    }

    boolean skipMigration(int checksum, LocalMigrationResource local, MigrationMetaRow existing) throws SQLException {
        boolean matchChecksum;
        boolean bl = matchChecksum = existing.getChecksum() == checksum;
        if (matchChecksum) {
            logger.trace("... skip unchanged migration {}", (Object)local.getLocation());
            return true;
        }
        if (this.patchResetChecksum(existing, checksum)) {
            logger.info("patch migration - reset checksum on {}", (Object)local.getLocation());
            return true;
        }
        if (local.isRepeatable() || this.skipChecksum) {
            return false;
        }
        throw new MigrationException("Checksum mismatch on migration " + local.getLocation());
    }

    private boolean patchResetChecksum(MigrationMetaRow existing, int newChecksum) throws SQLException {
        if (this.isResetOnVersion(existing.getVersion())) {
            if (!this.checkState) {
                existing.resetChecksum(newChecksum, this.connection, this.updateChecksumSql);
            }
            return true;
        }
        return false;
    }

    private boolean isResetOnVersion(String version) {
        return this.patchResetChecksumVersions != null && this.patchResetChecksumVersions.contains(version);
    }

    private void executeMigration(LocalMigrationResource local, String script, int checksum, MigrationMetaRow existing) throws SQLException {
        if (this.checkState) {
            this.checkMigrations.add(local);
            this.addMigration(local.key(), this.createMetaRow(local, checksum, 1L));
            return;
        }
        logger.debug("run migration {}", (Object)local.getLocation());
        long start = System.currentTimeMillis();
        try {
            if (local instanceof LocalDdlMigrationResource) {
                this.scriptRunner.runScript(script, "run migration version: " + local.getVersion());
            } else {
                JdbcMigration migration = ((LocalJdbcMigrationResource)local).getMigration();
                logger.info("Executing jdbc migration version: {} - {}", (Object)local.getVersion(), (Object)migration);
                migration.migrate(this.connection);
            }
            long exeMillis = System.currentTimeMillis() - start;
            if (existing != null) {
                existing.rerun(checksum, exeMillis, this.envUserName, this.runOn);
                existing.executeUpdate(this.connection, this.updateSql);
            } else {
                this.insertIntoHistory(local, checksum, exeMillis);
            }
        }
        catch (SQLException e) {
            if (this.allowErrorInRepeatable && local.isRepeatableLast()) {
                logger.error("Continue migration with error executing repeatable migration " + local.getVersion(), (Throwable)e);
            }
            throw e;
        }
    }

    private void insertIntoHistory(LocalMigrationResource local, int checksum, long exeMillis) throws SQLException {
        MigrationMetaRow metaRow = this.createMetaRow(local, checksum, exeMillis);
        metaRow.executeInsert(this.connection, this.insertSql);
        this.addMigration(local.key(), metaRow);
    }

    private MigrationMetaRow createInitMetaRow() {
        return new MigrationMetaRow(0, "I", INIT_VER_0, "<init>", 0, this.envUserName, this.runOn, 0L);
    }

    private MigrationMetaRow createMetaRow(LocalMigrationResource migration, int checksum, long exeMillis) {
        int nextId = 1;
        if (this.lastMigration != null) {
            nextId = this.lastMigration.getId() + 1;
        }
        String type = migration.getType();
        String runVersion = migration.key();
        String comment = migration.getComment();
        return new MigrationMetaRow(nextId, type, runVersion, comment, checksum, this.envUserName, this.runOn, exeMillis);
    }

    private boolean migrationExists(LocalMigrationResource priorVersion) {
        return this.migrations.containsKey(priorVersion.key());
    }

    private String convertScript(String script) {
        return this.scriptTransform.transform(script);
    }

    private void addMigration(String key, MigrationMetaRow metaRow) {
        if (INIT_VER_0.equals(key)) {
            return;
        }
        this.lastMigration = metaRow;
        if (metaRow.getVersion() == null) {
            throw new IllegalStateException("No runVersion in db migration table row? " + metaRow);
        }
        this.migrations.put(key, metaRow);
        if ("V".equals(metaRow.getType()) || "B".equals(metaRow.getType())) {
            MigrationVersion rowVersion = MigrationVersion.parse(metaRow.getVersion());
            if (this.currentVersion == null || rowVersion.compareTo(this.currentVersion) > 0) {
                this.currentVersion = rowVersion;
            }
            if ("B".equals(metaRow.getType())) {
                this.dbInitVersion = rowVersion;
            }
        }
    }

    public boolean isEmpty() {
        return this.migrations.isEmpty();
    }

    public List<LocalMigrationResource> runAll(List<LocalMigrationResource> localVersions) throws SQLException {
        this.checkMinVersion();
        for (LocalMigrationResource localVersion : localVersions) {
            if (!localVersion.isRepeatable() && this.dbInitVersion != null && this.dbInitVersion.compareTo(localVersion.getVersion()) >= 0) {
                logger.debug("migration skipped by dbInitVersion {}", (Object)this.dbInitVersion);
                continue;
            }
            if (this.shouldRun(localVersion, this.priorVersion)) continue;
            break;
        }
        return this.checkMigrations;
    }

    private void checkMinVersion() {
        if (this.minVersion != null && this.currentVersion != null && this.currentVersion.compareTo(this.minVersion) < 0) {
            StringBuilder sb = new StringBuilder();
            if (this.minVersionFailMessage != null && !this.minVersionFailMessage.isEmpty()) {
                sb.append(this.minVersionFailMessage).append(' ');
            }
            sb.append("MigrationVersion mismatch: v").append(this.currentVersion).append(" < v").append(this.minVersion);
            throw new MigrationException(sb.toString());
        }
    }

    public List<LocalMigrationResource> runInit(LocalMigrationResource initVersion, List<LocalMigrationResource> localVersions) throws SQLException {
        this.runRepeatableInit(localVersions);
        initVersion.setInitType();
        if (!this.shouldRun(initVersion, null)) {
            throw new IllegalStateException("Expected to run init migration but it didn't?");
        }
        for (LocalMigrationResource localVersion : localVersions) {
            if (localVersion.compareTo(initVersion) > 0 && !this.shouldRun(localVersion, this.priorVersion)) break;
        }
        return this.checkMigrations;
    }

    private void runRepeatableInit(List<LocalMigrationResource> localVersions) throws SQLException {
        for (LocalMigrationResource localVersion : localVersions) {
            if (!localVersion.isRepeatableInit() || !this.shouldRun(localVersion, this.priorVersion)) break;
        }
    }

    public void runNonTransactional() {
        this.scriptRunner.runNonTransactional();
    }
}

