/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.migration.runner;

import io.ebean.ddlrunner.DdlAutoCommit;
import io.ebean.migration.runner.MigrationMetaRow;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class MigrationPlatform {
    private static final String BASE_SELECT_ID = "select id from ";
    private static final String BASE_SELECT_ALL = "select id, mtype, mstatus, mversion, mcomment, mchecksum, run_on, run_by, run_time from ";
    String forUpdateSuffix = " order by id for update";

    DdlAutoCommit ddlAutoCommit() {
        return DdlAutoCommit.NONE;
    }

    void lockMigrationTable(String sqlTable, Connection connection) throws SQLException {
        String selectSql = this.sqlSelectForUpdate(sqlTable);
        try (PreparedStatement query = connection.prepareStatement(selectSql);
             ResultSet resultSet = query.executeQuery();){
            while (resultSet.next()) {
                resultSet.getInt(1);
            }
        }
    }

    @Nonnull
    List<MigrationMetaRow> readExistingMigrations(String sqlTable, Connection connection) throws SQLException {
        String selectSql = this.sqlSelectForReading(sqlTable);
        ArrayList<MigrationMetaRow> rows = new ArrayList<MigrationMetaRow>();
        try (PreparedStatement query = connection.prepareStatement(selectSql);
             ResultSet resultSet = query.executeQuery();){
            while (resultSet.next()) {
                rows.add(new MigrationMetaRow(resultSet));
            }
        }
        return rows;
    }

    @Nonnull
    String sqlSelectForUpdate(String table) {
        return BASE_SELECT_ID + table + this.forUpdateSuffix;
    }

    @Nonnull
    String sqlSelectForReading(String table) {
        return BASE_SELECT_ALL + table + this.forUpdateSuffix;
    }

    public static class NoLocking
    extends MigrationPlatform {
        public NoLocking() {
            this.forUpdateSuffix = " order by id";
        }

        @Override
        void lockMigrationTable(String sqlTable, Connection connection) {
        }
    }

    public static class SqlServer
    extends MigrationPlatform {
        public SqlServer() {
            this.forUpdateSuffix = " with (updlock) order by id";
        }
    }

    public static class Postgres
    extends MigrationPlatform {
        @Override
        DdlAutoCommit ddlAutoCommit() {
            return DdlAutoCommit.POSTGRES;
        }

        @Override
        void lockMigrationTable(String sqlTable, Connection connection) throws SQLException {
            try (PreparedStatement query = connection.prepareStatement("lock table " + sqlTable);){
                query.execute();
            }
        }
    }
}

