/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.migration;

import io.avaje.applog.AppLog;
import io.ebean.migration.MigrationConfig;
import io.ebean.migration.MigrationResource;
import io.ebean.migration.runner.MigrationEngine;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;

public class MigrationRunner {
    static final System.Logger log = AppLog.getLogger((String)"io.ebean.migration");
    protected final MigrationConfig migrationConfig;

    public MigrationRunner(MigrationConfig migrationConfig) {
        this.migrationConfig = migrationConfig;
    }

    public List<MigrationResource> checkState() {
        return this.checkState(this.migrationConfig.createConnection());
    }

    public List<MigrationResource> checkState(DataSource dataSource) {
        return this.checkState(this.connection(dataSource));
    }

    public List<MigrationResource> checkState(Connection connection) {
        return this.run(connection, true);
    }

    public void run() {
        this.run(this.migrationConfig.createConnection());
    }

    public void run(DataSource dataSource) {
        this.run(this.connection(dataSource));
    }

    public void run(Connection connection) {
        this.run(connection, false);
    }

    private Connection connection(DataSource dataSource) {
        String username = this.migrationConfig.getDbUsername();
        try {
            if (username == null) {
                return dataSource.getConnection();
            }
            log.log(System.Logger.Level.DEBUG, "using db user [{0}] to run migrations ...", username);
            return dataSource.getConnection(username, this.migrationConfig.getDbPassword());
        }
        catch (SQLException e) {
            Object msgSuffix = username == null ? "" : " using user [" + username + "]";
            throw new IllegalArgumentException("Error trying to connect to database for DB Migration" + (String)msgSuffix, e);
        }
    }

    private List<MigrationResource> run(Connection connection, boolean checkStateOnly) {
        return new MigrationEngine(this.migrationConfig, checkStateOnly).run(connection);
    }
}

