/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.migration.runner;

import io.avaje.classpath.scanner.Resource;
import io.avaje.classpath.scanner.core.Scanner;
import io.ebean.migration.JdbcMigration;
import io.ebean.migration.MigrationConfig;
import io.ebean.migration.MigrationVersion;
import io.ebean.migration.runner.LocalDdlMigrationResource;
import io.ebean.migration.runner.LocalJdbcMigrationResource;
import io.ebean.migration.runner.LocalMigrationResource;
import io.ebean.migration.runner.LocalUriMigrationResource;
import io.ebean.migration.runner.MigrationSchema;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;

final class LocalMigrationResources {
    private static final System.Logger log = MigrationSchema.log;
    private final List<LocalMigrationResource> versions = new ArrayList<LocalMigrationResource>();
    private final MigrationConfig migrationConfig;
    private final ClassLoader classLoader;
    private final boolean searchForJdbcMigrations;

    LocalMigrationResources(MigrationConfig migrationConfig) {
        this.migrationConfig = migrationConfig;
        this.classLoader = migrationConfig.getClassLoader();
        this.searchForJdbcMigrations = migrationConfig.getJdbcMigrationFactory() != null;
    }

    boolean readInitResources() {
        return this.readResourcesForPath(this.migrationConfig.getMigrationInitPath());
    }

    boolean readResources() {
        if (this.readFromIndex()) {
            this.migrationConfig.setEarlyChecksumMode(true);
            return true;
        }
        return this.readResourcesForPath(this.migrationConfig.getMigrationPath());
    }

    private boolean readFromIndex() {
        String basePlatform;
        String indexName;
        String base = "/" + this.migrationConfig.getMigrationPath() + "/";
        URL idx = this.resource(base + (indexName = "idx_" + (basePlatform = this.migrationConfig.getBasePlatform()) + ".migrations"));
        if (idx != null) {
            return this.loadFromIndexFile(idx, base);
        }
        idx = this.resource(base + basePlatform + "/" + indexName);
        if (idx != null) {
            return this.loadFromIndexFile(idx, base + basePlatform + "/");
        }
        String platform = this.migrationConfig.getPlatform();
        idx = this.resource(base + platform + indexName);
        if (idx != null) {
            return this.loadFromIndexFile(idx, base + platform + "/");
        }
        return false;
    }

    private URL resource(String base) {
        return LocalMigrationResources.class.getResource(base);
    }

    private boolean loadFromIndexFile(URL idx, String base) {
        boolean bl;
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(idx.openStream()));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                String[] pair;
                if (line.isEmpty() || (pair = line.split(",")).length != 2) continue;
                int checksum = Integer.parseInt(pair[0]);
                String location = pair[1].trim();
                String substring = location.substring(0, location.length() - 4);
                MigrationVersion version = MigrationVersion.parse(substring);
                URL url = this.resource(base + location);
                this.versions.add(new LocalUriMigrationResource(version, location, url, checksum));
            }
            bl = !this.versions.isEmpty();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException("Error reading idx file", e);
            }
        }
        reader.close();
        return bl;
    }

    private boolean readResourcesForPath(String path) {
        String basePlatform = this.migrationConfig.getBasePlatform();
        if (basePlatform != null && this.loadedFrom(path, basePlatform)) {
            return true;
        }
        String platform = this.migrationConfig.getPlatform();
        if (platform != null && this.loadedFrom(path, platform)) {
            return true;
        }
        this.addResources(this.scanForBoth(path));
        Collections.sort(this.versions);
        return !this.versions.isEmpty();
    }

    private boolean loadedFrom(String path, String platform) {
        this.addResources(this.scanForBoth(path + "/" + platform));
        if (this.versions.isEmpty()) {
            return false;
        }
        log.log(System.Logger.Level.DEBUG, "platform migrations for {0}", platform);
        if (this.searchForJdbcMigrations) {
            this.addResources(this.scanForJdbcOnly(path));
        }
        Collections.sort(this.versions);
        return true;
    }

    private List<Resource> scanForJdbcOnly(String path) {
        return new Scanner(this.classLoader).scanForResources(path, (Predicate)new JdbcOnly());
    }

    private List<Resource> scanForBoth(String path) {
        return new Scanner(this.classLoader).scanForResources(path, (Predicate)new Match(this.searchForJdbcMigrations));
    }

    private void addResources(List<Resource> resourceList) {
        if (!resourceList.isEmpty()) {
            log.log(System.Logger.Level.DEBUG, "resources: {0}", resourceList);
        }
        for (Resource resource : resourceList) {
            String filename = resource.name();
            if (filename.endsWith(".sql")) {
                this.versions.add(this.createScriptMigration(resource, filename));
                continue;
            }
            if (!this.searchForJdbcMigrations || !filename.endsWith(".class")) continue;
            this.versions.add(this.createJdbcMigration(resource, filename));
        }
    }

    private LocalMigrationResource createJdbcMigration(Resource resource, String filename) {
        int pos = filename.lastIndexOf(".class");
        String mainName = filename.substring(0, pos);
        MigrationVersion migrationVersion = MigrationVersion.parse(mainName);
        String className = resource.location().replace('/', '.');
        className = className.substring(0, className.length() - 6);
        JdbcMigration instance = this.migrationConfig.getJdbcMigrationFactory().createInstance(className);
        return new LocalJdbcMigrationResource(migrationVersion, resource.location(), instance);
    }

    private LocalMigrationResource createScriptMigration(Resource resource, String filename) {
        int pos = filename.lastIndexOf(".sql");
        String mainName = filename.substring(0, pos);
        MigrationVersion migrationVersion = MigrationVersion.parse(mainName);
        return new LocalDdlMigrationResource(migrationVersion, resource.location(), resource);
    }

    List<LocalMigrationResource> versions() {
        return this.versions;
    }

    private static final class JdbcOnly
    implements Predicate<String> {
        private JdbcOnly() {
        }

        @Override
        public boolean test(String name) {
            return name.endsWith(".class") && !name.contains("$");
        }
    }

    private static final class Match
    implements Predicate<String> {
        private final boolean searchJdbc;

        Match(boolean searchJdbc) {
            this.searchJdbc = searchJdbc;
        }

        @Override
        public boolean test(String name) {
            return name.endsWith(".sql") || this.searchJdbc && name.endsWith(".class") && !name.contains("$");
        }
    }
}

