/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.migration.runner;

import io.avaje.applog.AppLog;
import io.ebean.migration.MigrationConfig;
import io.ebean.migration.MigrationException;
import io.ebean.migration.MigrationResource;
import io.ebean.migration.runner.Checksum;
import io.ebean.migration.runner.DbNameUtil;
import io.ebean.migration.runner.LocalDdlMigrationResource;
import io.ebean.migration.runner.LocalJdbcMigrationResource;
import io.ebean.migration.runner.LocalMigrationResource;
import io.ebean.migration.runner.LocalMigrationResources;
import io.ebean.migration.runner.LocalUriMigrationResource;
import io.ebean.migration.runner.MigrationMetaRow;
import io.ebean.migration.runner.MigrationPlatform;
import io.ebean.migration.runner.MigrationTable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MigrationEngine {
    static final System.Logger log = AppLog.getLogger((String)"io.ebean.migration");
    private final MigrationConfig migrationConfig;
    private final boolean checkStateOnly;
    private final boolean fastMode;
    private int fastModeCount;
    private MigrationTable table;

    public MigrationEngine(MigrationConfig migrationConfig, boolean checkStateOnly) {
        this.migrationConfig = migrationConfig;
        this.checkStateOnly = checkStateOnly;
        this.fastMode = !checkStateOnly && migrationConfig.isFastMode();
    }

    /*
     * Exception decompiling
     */
    public List<MigrationResource> run(Connection connection) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void setAutoCommitFalse(Connection connection) {
        try {
            connection.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new MigrationException("Error running DB migrations", e);
        }
    }

    private MigrationTable initMigrationTable(Connection connection) {
        MigrationPlatform platform = this.derivePlatformName(this.migrationConfig, connection);
        return new MigrationTable(this.migrationConfig, connection, this.checkStateOnly, platform);
    }

    private boolean fastModeCheck(List<LocalMigrationResource> versions) {
        try {
            List<MigrationMetaRow> rows = this.table.fastRead();
            if (rows.size() != versions.size() + 1) {
                return false;
            }
            Map<String, Integer> dbChecksums = MigrationEngine.dbChecksumMap(rows);
            for (LocalMigrationResource local : versions) {
                Integer dbChecksum = dbChecksums.get(local.key());
                if (dbChecksum == null) {
                    return false;
                }
                int localChecksum = this.checksumFor(local);
                if (localChecksum == dbChecksum) continue;
                return false;
            }
            this.fastModeCount = versions.size();
            return true;
        }
        catch (SQLException e) {
            return false;
        }
    }

    private static Map<String, Integer> dbChecksumMap(List<MigrationMetaRow> rows) {
        return rows.stream().collect(Collectors.toMap(MigrationMetaRow::version, MigrationMetaRow::checksum));
    }

    private int checksumFor(LocalMigrationResource local) {
        if (local instanceof LocalUriMigrationResource) {
            return ((LocalUriMigrationResource)local).checksum();
        }
        if (local instanceof LocalDdlMigrationResource) {
            return Checksum.calculate(local.content());
        }
        return ((LocalJdbcMigrationResource)local).checksum();
    }

    private void initialiseMigrationTable(Connection connection) {
        try {
            this.table.createIfNeededAndLock();
        }
        catch (Throwable e) {
            MigrationEngine.rollback(connection);
            throw new MigrationException("Error initialising db migrations table", e);
        }
    }

    private List<MigrationResource> runMigrations(List<LocalMigrationResource> localVersions) throws SQLException {
        LocalMigrationResource initVersion;
        if (this.table.isEmpty() && (initVersion = this.lastInitVersion()) != null) {
            log.log(System.Logger.Level.INFO, "dbinit migration version:{0}  local migrations:{1}  checkState:{2}", initVersion, localVersions.size(), this.checkStateOnly);
            return this.table.runInit(initVersion, localVersions);
        }
        return this.table.runAll(localVersions);
    }

    private LocalMigrationResource lastInitVersion() {
        List<LocalMigrationResource> initVersions;
        LocalMigrationResources initResources = new LocalMigrationResources(this.migrationConfig);
        if (initResources.readInitResources() && !(initVersions = initResources.versions()).isEmpty()) {
            return initVersions.get(initVersions.size() - 1);
        }
        return null;
    }

    private MigrationPlatform derivePlatformName(MigrationConfig migrationConfig, Connection connection) {
        String platform = migrationConfig.getPlatform();
        if (platform != null) {
            return DbNameUtil.platform(platform);
        }
        String derivedPlatformName = DbNameUtil.normalise(connection);
        migrationConfig.setPlatform(derivedPlatformName);
        return DbNameUtil.platform(derivedPlatformName);
    }

    private void close(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException e) {
            log.log(System.Logger.Level.WARNING, "Error closing connection", (Throwable)e);
        }
    }

    static void rollback(Connection connection) {
        try {
            if (connection != null) {
                connection.rollback();
            }
        }
        catch (SQLException e) {
            log.log(System.Logger.Level.WARNING, "Error on connection rollback", (Throwable)e);
        }
    }
}

