/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.migration.runner;

import io.ebean.ddlrunner.DdlDetect;
import io.ebean.migration.MigrationException;
import io.ebean.migration.runner.MigrationEngine;
import io.ebean.migration.runner.MigrationMetaRow;
import io.ebean.migration.runner.MigrationTable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

class MigrationPlatform {
    private static final System.Logger log = MigrationTable.log;
    private static final String BASE_SELECT_ID = "select id from ";
    private static final String BASE_SELECT = "select id, mtype, mversion, mchecksum from ";
    private static final String SELECT_FAST_READ = "select mchecksum, mversion from ";
    String forUpdateSuffix = " order by id for update";

    MigrationPlatform() {
    }

    DdlDetect ddlDetect() {
        return DdlDetect.NONE;
    }

    void unlockMigrationTable(String sqlTable, Connection connection) {
    }

    void lockMigrationTable(String sqlTable, Connection connection) throws SQLException {
        for (int attempt = 0; attempt < 5; ++attempt) {
            if (this.lockRows(sqlTable, connection) > 0) {
                return;
            }
            MigrationPlatform.backoff(attempt);
        }
        throw new IllegalStateException("Failed to obtain row locks on migration table due to it being empty?");
    }

    private static void backoff(int attempt) {
        try {
            if (attempt % 100 == 0) {
                log.log(System.Logger.Level.WARNING, "In backoff loop attempting to obtain lock on DBMigration table ...");
            } else {
                log.log(System.Logger.Level.TRACE, "in backoff loop obtaining lock...");
            }
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while trying to obtain lock on migration table", e);
        }
    }

    private int lockRows(String sqlTable, Connection connection) throws SQLException {
        int rowCount = 0;
        try (Statement query = connection.createStatement();
             ResultSet resultSet = query.executeQuery(this.sqlSelectForUpdate(sqlTable));){
            while (resultSet.next()) {
                resultSet.getInt(1);
                ++rowCount;
            }
        }
        return rowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<MigrationMetaRow> fastReadMigrations(String sqlTable, Connection connection) throws SQLException {
        ArrayList<MigrationMetaRow> rows = new ArrayList<MigrationMetaRow>();
        try (Statement query = connection.createStatement();
             ResultSet resultSet = query.executeQuery(this.sqlSelectForFastRead(sqlTable));){
            while (resultSet.next()) {
                rows.add(MigrationMetaRow.fastRead(resultSet));
            }
        }
        finally {
            connection.rollback();
        }
        return rows;
    }

    List<MigrationMetaRow> readExistingMigrations(String sqlTable, Connection connection) throws SQLException {
        String selectSql = this.sqlSelectForReading(sqlTable);
        ArrayList<MigrationMetaRow> rows = new ArrayList<MigrationMetaRow>();
        try (Statement query = connection.createStatement();
             ResultSet resultSet = query.executeQuery(selectSql);){
            while (resultSet.next()) {
                rows.add(new MigrationMetaRow(resultSet));
            }
        }
        return rows;
    }

    String sqlSelectForUpdate(String table) {
        return BASE_SELECT_ID + table + this.forUpdateSuffix;
    }

    String sqlSelectForReading(String table) {
        return BASE_SELECT + table + this.forUpdateSuffix;
    }

    String sqlSelectForFastRead(String table) {
        return SELECT_FAST_READ + table;
    }

    static final class NoLocking
    extends MigrationPlatform {
        NoLocking() {
            this.forUpdateSuffix = " order by id";
        }

        @Override
        void lockMigrationTable(String sqlTable, Connection connection) {
        }
    }

    static final class SqlServer
    extends MigrationPlatform {
        SqlServer() {
            this.forUpdateSuffix = " with (updlock) order by id";
        }
    }

    static final class MySql
    extends MigrationPlatform {
        MySql() {
        }

        @Override
        void lockMigrationTable(String sqlTable, Connection connection) throws SQLException {
            int attempts = 0;
            while (!this.obtainNamedLock(connection)) {
                MigrationPlatform.backoff(++attempts);
            }
        }

        private boolean obtainNamedLock(Connection connection) throws SQLException {
            String hash = Integer.toHexString(connection.getMetaData().getURL().hashCode());
            try (Statement query = connection.createStatement();
                 ResultSet resultSet = query.executeQuery("select get_lock('ebean_migration-" + hash + "', 10)");){
                if (resultSet.next()) {
                    boolean bl = resultSet.getInt(1) == 1;
                    return bl;
                }
            }
            return false;
        }

        @Override
        void unlockMigrationTable(String sqlTable, Connection connection) {
            try {
                String hash = Integer.toHexString(connection.getMetaData().getURL().hashCode());
                try (Statement query = connection.createStatement();){
                    query.execute("select release_lock('ebean_migration-" + hash + "')");
                }
            }
            catch (SQLException e) {
                throw new MigrationException("Error releasing lock for ebean_migration", e);
            }
        }
    }

    static final class Postgres
    extends MigrationPlatform {
        Postgres() {
        }

        @Override
        DdlDetect ddlDetect() {
            return DdlDetect.POSTGRES;
        }

        @Override
        void lockMigrationTable(String sqlTable, Connection connection) throws SQLException {
            try (Statement query = connection.createStatement();){
                query.executeUpdate("lock table " + sqlTable);
            }
        }
    }

    static final class LogicalLock
    extends MigrationPlatform {
        LogicalLock() {
        }

        @Override
        void lockMigrationTable(String sqlTable, Connection connection) throws SQLException {
            int attempts = 0;
            while (!this.obtainLogicalLock(sqlTable, connection)) {
                MigrationPlatform.backoff(++attempts);
            }
            log.log(System.Logger.Level.TRACE, "obtained logical lock");
        }

        @Override
        void unlockMigrationTable(String sqlTable, Connection connection) {
            try {
                this.releaseLogicalLock(sqlTable, connection);
                connection.commit();
            }
            catch (SQLException e) {
                MigrationEngine.rollback(connection);
                throw new MigrationException("Error releasing logical lock for ebean migrations");
            }
        }

        private boolean obtainLogicalLock(String sqlTable, Connection connection) throws SQLException {
            try (PreparedStatement query = connection.prepareStatement("update " + sqlTable + " set mcomment=? where id=? and mcomment=?");){
                query.setString(1, "locked");
                query.setInt(2, 0);
                query.setString(3, "<init>");
                if (query.executeUpdate() == 1) {
                    connection.commit();
                    boolean bl = true;
                    return bl;
                }
                connection.rollback();
                boolean bl = false;
                return bl;
            }
        }

        private void releaseLogicalLock(String sqlTable, Connection connection) throws SQLException {
            String sql = "update " + sqlTable + " set mcomment='<init>' where id=0";
            try (Statement query = connection.createStatement();){
                if (query.executeUpdate(sql) != 1) {
                    log.log(System.Logger.Level.ERROR, "Failed to release logical lock. Please review why [" + sql + "] didn't update the row?");
                } else {
                    log.log(System.Logger.Level.TRACE, "released logical lock");
                }
            }
        }
    }
}

