/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.migration.runner;

import io.avaje.applog.AppLog;
import io.ebean.ddlrunner.ScriptTransform;
import io.ebean.migration.JdbcMigration;
import io.ebean.migration.MigrationConfig;
import io.ebean.migration.MigrationException;
import io.ebean.migration.MigrationResource;
import io.ebean.migration.MigrationVersion;
import io.ebean.migration.runner.Checksum;
import io.ebean.migration.runner.IOUtils;
import io.ebean.migration.runner.LocalDdlMigrationResource;
import io.ebean.migration.runner.LocalJdbcMigrationResource;
import io.ebean.migration.runner.LocalMigrationResource;
import io.ebean.migration.runner.LocalUriMigrationResource;
import io.ebean.migration.runner.MigrationMetaRow;
import io.ebean.migration.runner.MigrationPlatform;
import io.ebean.migration.runner.MigrationSchema;
import io.ebean.migration.runner.MigrationScriptRunner;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

final class MigrationTable {
    static final System.Logger log = AppLog.getLogger((String)"io.ebean.DDL");
    private static final String INIT_VER_0 = "0";
    private static final int LEGACY_MODE_CHECKSUM = 0;
    private static final int EARLY_MODE_CHECKSUM = 1;
    private static final int AUTO_PATCH_CHECKSUM = -1;
    private final MigrationConfig config;
    private final Connection connection;
    private final boolean checkStateOnly;
    private boolean earlyChecksumMode;
    private final MigrationPlatform platform;
    private final MigrationScriptRunner scriptRunner;
    private final String catalog;
    private final String schema;
    private final String table;
    private final String sqlTable;
    private final String envUserName;
    private final String basePlatformName;
    private final String platformName;
    private final Timestamp runOn = new Timestamp(System.currentTimeMillis());
    private final ScriptTransform scriptTransform;
    private final String insertSql;
    private final String updateSql;
    private final String updateChecksumSql;
    private final LinkedHashMap<String, MigrationMetaRow> migrations;
    private final boolean skipChecksum;
    private final boolean skipMigrationRun;
    private final Set<String> patchInsertVersions;
    private final Set<String> patchResetChecksumVersions;
    private final boolean allowErrorInRepeatable;
    private final MigrationVersion minVersion;
    private final String minVersionFailMessage;
    private MigrationVersion currentVersion;
    private MigrationMetaRow lastMigration;
    private LocalMigrationResource priorVersion;
    private final List<MigrationResource> checkMigrations = new ArrayList<MigrationResource>();
    private MigrationVersion dbInitVersion;
    private int executionCount;
    private boolean patchLegacyChecksums;
    private MigrationMetaRow initMetaRow;
    private boolean tableKnownToExist;

    MigrationTable(MigrationConfig config, Connection connection, boolean checkStateOnly, MigrationPlatform platform) {
        this.config = config;
        this.platform = platform;
        this.connection = connection;
        this.scriptRunner = new MigrationScriptRunner(connection, platform);
        this.checkStateOnly = checkStateOnly;
        this.earlyChecksumMode = config.isEarlyChecksumMode();
        this.migrations = new LinkedHashMap();
        this.catalog = null;
        this.allowErrorInRepeatable = config.isAllowErrorInRepeatable();
        this.patchResetChecksumVersions = config.getPatchResetChecksumOn();
        this.patchInsertVersions = config.getPatchInsertOn();
        this.minVersion = this.initMinVersion(config.getMinVersion());
        this.minVersionFailMessage = config.getMinVersionFailMessage();
        this.skipMigrationRun = config.isSkipMigrationRun();
        this.skipChecksum = config.isSkipChecksum();
        this.schema = config.getDbSchema();
        this.table = config.getMetaTable();
        this.basePlatformName = config.getBasePlatform();
        this.platformName = config.getPlatform();
        this.sqlTable = this.initSqlTable();
        this.insertSql = MigrationMetaRow.insertSql(this.sqlTable);
        this.updateSql = MigrationMetaRow.updateSql(this.sqlTable);
        this.updateChecksumSql = MigrationMetaRow.updateChecksumSql(this.sqlTable);
        this.scriptTransform = this.createScriptTransform(config);
        this.envUserName = System.getProperty("user.name");
    }

    private MigrationVersion initMinVersion(String minVersion) {
        return minVersion == null || minVersion.isEmpty() ? null : MigrationVersion.parse(minVersion);
    }

    private String initSqlTable() {
        if (this.schema != null) {
            return this.schema + "." + this.table;
        }
        return this.table;
    }

    private String sqlPrimaryKey() {
        return "pk_" + this.table;
    }

    int size() {
        return this.migrations.size();
    }

    Set<String> versions() {
        return this.migrations.keySet();
    }

    private ScriptTransform createScriptTransform(MigrationConfig config) {
        return ScriptTransform.build((String)config.getRunPlaceholders(), config.getRunPlaceholderMap());
    }

    void createIfNeededAndLock() throws SQLException, IOException {
        SQLException suppressedException = null;
        if (!this.tableKnownToExist) {
            MigrationSchema.createIfNeeded(this.config, this.connection);
            if (!this.tableExists()) {
                try {
                    this.createTable();
                }
                catch (SQLException e) {
                    if (this.tableExists()) {
                        suppressedException = e;
                        log.log(System.Logger.Level.INFO, "Ignoring error during table creation, as an other process may have created the table", (Throwable)e);
                    }
                    throw e;
                }
            }
        }
        try {
            this.obtainLockWithWait();
        }
        catch (RuntimeException re) {
            if (suppressedException != null) {
                re.addSuppressed(suppressedException);
            }
            throw re;
        }
        this.readExistingMigrations();
    }

    private void obtainLockWithWait() throws SQLException {
        this.platform.lockMigrationTable(this.sqlTable, this.connection);
    }

    void unlockMigrationTable() {
        this.platform.unlockMigrationTable(this.sqlTable, this.connection);
    }

    List<MigrationMetaRow> fastRead() throws SQLException {
        List<MigrationMetaRow> result = this.platform.fastReadMigrations(this.sqlTable, this.connection);
        this.tableKnownToExist = !result.isEmpty();
        return result;
    }

    private void readExistingMigrations() throws SQLException {
        for (MigrationMetaRow metaRow : this.platform.readExistingMigrations(this.sqlTable, this.connection)) {
            this.addMigration(metaRow.version(), metaRow);
        }
    }

    void createTable() throws IOException, SQLException {
        try {
            this.scriptRunner.runScript(this.createTableDdl(), "create migration table");
            this.createInitMetaRow().executeInsert(this.connection, this.insertSql);
            this.connection.commit();
        }
        catch (SQLException e) {
            this.connection.rollback();
            throw e;
        }
    }

    String createTableDdl() throws IOException {
        String script = ScriptTransform.replace((String)"${table}", (String)this.sqlTable, (String)this.createTableScript());
        return ScriptTransform.replace((String)"${pk_table}", (String)this.sqlPrimaryKey(), (String)script);
    }

    private String createTableScript() throws IOException {
        String script = this.readResource("migration-support/create-table.sql");
        if (script == null && this.platformName != null && !this.platformName.isEmpty()) {
            script = this.readResource("migration-support/" + this.platformName + "-create-table.sql");
        }
        if (script == null && this.basePlatformName != null && !this.basePlatformName.isEmpty()) {
            script = this.readResource("migration-support/" + this.basePlatformName + "-create-table.sql");
        }
        if (script == null) {
            script = this.readResource("migration-support/default-create-table.sql");
        }
        return script;
    }

    private String readResource(String location) throws IOException {
        Enumeration<URL> resources = this.classLoader().getResources(location);
        if (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            return IOUtils.readUtf8(url);
        }
        return null;
    }

    private ClassLoader classLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    boolean tableExists() throws SQLException {
        String migTable = this.table;
        DatabaseMetaData metaData = this.connection.getMetaData();
        if (metaData.storesUpperCaseIdentifiers()) {
            migTable = migTable.toUpperCase();
        }
        String checkCatalog = this.catalog != null ? this.catalog : this.trim(this.connection.getCatalog());
        String checkSchema = this.schema != null ? this.schema : this.trim(this.connection.getSchema());
        try (ResultSet tables = metaData.getTables(checkCatalog, checkSchema, migTable, null);){
            boolean bl = tables.next();
            return bl;
        }
    }

    private String trim(String s) {
        return s == null ? null : s.trim();
    }

    private boolean shouldRun(LocalMigrationResource localVersion, LocalMigrationResource prior) throws SQLException {
        if (prior != null && !localVersion.isRepeatable() && !this.migrationExists(prior)) {
            log.log(System.Logger.Level.ERROR, "Migration {0} requires prior migration {1} which has not been run", localVersion.version(), prior.version());
            return false;
        }
        MigrationMetaRow existing = this.migrations.get(localVersion.key());
        if (!this.runMigration(localVersion, existing)) {
            return false;
        }
        this.priorVersion = localVersion;
        return true;
    }

    private boolean runMigration(LocalMigrationResource local, MigrationMetaRow existing) throws SQLException {
        int checksum;
        String script = null;
        int checksum2 = 0;
        if (local instanceof LocalUriMigrationResource) {
            checksum = ((LocalUriMigrationResource)local).checksum();
            checksum2 = this.patchLegacyChecksums ? -1 : 0;
            script = this.convertScript(local.content());
        } else if (local instanceof LocalDdlMigrationResource) {
            String content = local.content();
            script = this.convertScript(content);
            checksum = Checksum.calculate(this.earlyChecksumMode ? content : script);
            checksum2 = this.patchLegacyChecksums ? Checksum.calculate(script) : 0;
        } else {
            checksum = ((LocalJdbcMigrationResource)local).checksum();
        }
        if (existing == null && this.patchInsertMigration(local, checksum)) {
            return true;
        }
        if (existing != null && this.skipMigration(checksum, checksum2, local, existing)) {
            return true;
        }
        this.executeMigration(local, script, checksum, existing);
        return true;
    }

    private boolean patchInsertMigration(LocalMigrationResource local, int checksum) throws SQLException {
        if (this.patchInsertVersions != null && this.patchInsertVersions.contains(local.key())) {
            log.log(System.Logger.Level.INFO, "Patch migration, insert into history {0}", local.location());
            if (!this.checkStateOnly) {
                this.insertIntoHistory(local, checksum, 0L);
            }
            return true;
        }
        return false;
    }

    boolean skipMigration(int checksum, int checksum2, LocalMigrationResource local, MigrationMetaRow existing) throws SQLException {
        boolean matchChecksum;
        boolean bl = matchChecksum = existing.checksum() == checksum;
        if (matchChecksum) {
            log.log(System.Logger.Level.TRACE, "skip unchanged migration {0}", local.location());
            return true;
        }
        if (this.patchLegacyChecksums && (existing.checksum() == checksum2 || checksum2 == -1)) {
            if (!this.checkStateOnly) {
                log.log(System.Logger.Level.INFO, "Auto patch migration, set early mode checksum on {0} to {1,number} from {2,number}", local.location(), checksum, existing.checksum());
                existing.resetChecksum(checksum, this.connection, this.updateChecksumSql);
            }
            return true;
        }
        if (this.patchResetChecksum(existing, checksum)) {
            log.log(System.Logger.Level.INFO, "Patch migration, reset checksum on {0} to {1,number} from {2,number}", local.location(), checksum, existing.checksum());
            return true;
        }
        if (local.isRepeatable() || this.skipChecksum) {
            return false;
        }
        throw new MigrationException("Checksum mismatch on migration " + local.location());
    }

    private boolean patchResetChecksum(MigrationMetaRow existing, int newChecksum) throws SQLException {
        if (this.isResetOnVersion(existing.version())) {
            if (!this.checkStateOnly) {
                existing.resetChecksum(newChecksum, this.connection, this.updateChecksumSql);
            }
            return true;
        }
        return false;
    }

    private boolean isResetOnVersion(String version) {
        return this.patchResetChecksumVersions != null && (this.patchResetChecksumVersions.contains(version) || this.patchResetChecksumVersions.contains("*"));
    }

    private void executeMigration(LocalMigrationResource local, String script, int checksum, MigrationMetaRow existing) throws SQLException {
        if (this.checkStateOnly) {
            this.checkMigrations.add(local);
            this.addMigration(local.key(), this.createMetaRow(local, checksum, 1L));
            return;
        }
        long exeMillis = 0L;
        try {
            if (this.skipMigrationRun) {
                log.log(System.Logger.Level.DEBUG, "skip migration {0}", local.location());
            } else {
                exeMillis = this.executeMigration(local, script);
            }
            if (existing != null) {
                existing.rerun(checksum, exeMillis, this.envUserName, this.runOn);
                existing.executeUpdate(this.connection, this.updateSql);
            } else {
                this.insertIntoHistory(local, checksum, exeMillis);
            }
        }
        catch (SQLException e) {
            if (this.allowErrorInRepeatable && local.isRepeatableLast()) {
                log.log(System.Logger.Level.ERROR, "Continue migration with error executing repeatable migration " + String.valueOf(local.version()), (Throwable)e);
            }
            throw e;
        }
    }

    private long executeMigration(LocalMigrationResource local, String script) throws SQLException {
        long start = System.currentTimeMillis();
        if (local instanceof LocalJdbcMigrationResource) {
            JdbcMigration migration = ((LocalJdbcMigrationResource)local).migration();
            log.log(System.Logger.Level.INFO, "Executing jdbc migration version: {0} - {1}", local.version(), migration);
            migration.migrate(this.connection);
        } else {
            log.log(System.Logger.Level.DEBUG, "run migration {0}", local.location());
            this.scriptRunner.runScript(script, "run migration version: " + String.valueOf(local.version()));
        }
        ++this.executionCount;
        return System.currentTimeMillis() - start;
    }

    private void insertIntoHistory(LocalMigrationResource local, int checksum, long exeMillis) throws SQLException {
        MigrationMetaRow metaRow = this.createMetaRow(local, checksum, exeMillis);
        metaRow.executeInsert(this.connection, this.insertSql);
        this.addMigration(local.key(), metaRow);
    }

    private MigrationMetaRow createInitMetaRow() {
        int mode = this.earlyChecksumMode ? 1 : 0;
        return new MigrationMetaRow(0, "I", INIT_VER_0, "<init>", mode, this.envUserName, this.runOn, 0L);
    }

    private MigrationMetaRow createMetaRow(LocalMigrationResource migration, int checksum, long exeMillis) {
        int nextId = 1;
        if (this.lastMigration != null) {
            nextId = this.lastMigration.id() + 1;
        }
        String type = migration.type();
        String runVersion = migration.key();
        String comment = migration.comment();
        return new MigrationMetaRow(nextId, type, runVersion, comment, checksum, this.envUserName, this.runOn, exeMillis);
    }

    private boolean migrationExists(LocalMigrationResource priorVersion) {
        return this.migrations.containsKey(priorVersion.key());
    }

    private String convertScript(String script) {
        return this.scriptTransform.transform(script);
    }

    private void addMigration(String key, MigrationMetaRow metaRow) {
        if (INIT_VER_0.equals(key)) {
            if (metaRow.checksum() == 1 && !this.earlyChecksumMode) {
                log.log(System.Logger.Level.DEBUG, "automatically detected earlyChecksumMode");
                this.earlyChecksumMode = true;
            }
            this.initMetaRow = metaRow;
            this.patchLegacyChecksums = this.earlyChecksumMode && metaRow.checksum() == 0;
            return;
        }
        this.lastMigration = metaRow;
        if (metaRow.version() == null) {
            throw new IllegalStateException("No runVersion in db migration table row? " + String.valueOf(metaRow));
        }
        this.migrations.put(key, metaRow);
        if ("V".equals(metaRow.type()) || "B".equals(metaRow.type())) {
            MigrationVersion rowVersion = MigrationVersion.parse(metaRow.version());
            if (this.currentVersion == null || rowVersion.compareTo(this.currentVersion) > 0) {
                this.currentVersion = rowVersion;
            }
            if ("B".equals(metaRow.type())) {
                this.dbInitVersion = rowVersion;
            }
        }
    }

    boolean isEmpty() {
        return this.migrations.isEmpty();
    }

    List<MigrationResource> runAll(List<LocalMigrationResource> localVersions) throws SQLException {
        this.checkMinVersion();
        for (LocalMigrationResource localVersion : localVersions) {
            if (!localVersion.isRepeatable() && this.dbInitVersion != null && this.dbInitVersion.compareTo(localVersion.version()) >= 0) {
                log.log(System.Logger.Level.DEBUG, "migration skipped by dbInitVersion {0}", this.dbInitVersion);
                continue;
            }
            if (this.shouldRun(localVersion, this.priorVersion)) continue;
            break;
        }
        if (this.patchLegacyChecksums && !this.checkStateOnly) {
            this.initMetaRow.resetChecksum(1, this.connection, this.updateChecksumSql);
        }
        return this.checkMigrations;
    }

    private void checkMinVersion() {
        if (this.minVersion != null && this.currentVersion != null && this.currentVersion.compareTo(this.minVersion) < 0) {
            StringBuilder sb = new StringBuilder();
            if (this.minVersionFailMessage != null && !this.minVersionFailMessage.isEmpty()) {
                sb.append(this.minVersionFailMessage).append(' ');
            }
            sb.append("MigrationVersion mismatch: v").append(this.currentVersion).append(" < v").append(this.minVersion);
            throw new MigrationException(sb.toString());
        }
    }

    List<MigrationResource> runInit(LocalMigrationResource initVersion, List<LocalMigrationResource> localVersions) throws SQLException {
        this.runRepeatableInit(localVersions);
        initVersion.setInitType();
        if (!this.shouldRun(initVersion, null)) {
            throw new IllegalStateException("Expected to run init migration but it didn't?");
        }
        for (LocalMigrationResource localVersion : localVersions) {
            if (localVersion.compareTo(initVersion) > 0 && !this.shouldRun(localVersion, this.priorVersion)) break;
        }
        return this.checkMigrations;
    }

    private void runRepeatableInit(List<LocalMigrationResource> localVersions) throws SQLException {
        for (LocalMigrationResource localVersion : localVersions) {
            if (!localVersion.isRepeatableInit() || !this.shouldRun(localVersion, this.priorVersion)) break;
        }
    }

    int runNonTransactional() {
        return this.scriptRunner.runNonTransactional();
    }

    int count() {
        return this.executionCount;
    }

    String mode() {
        return !this.earlyChecksumMode ? "legacy" : (this.patchLegacyChecksums ? "earlyChecksum with patching" : "earlyChecksum");
    }
}

