/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.migration.runner;

import io.ebean.migration.MigrationResource;
import io.ebean.migration.MigrationVersion;

abstract class LocalMigrationResource
implements MigrationResource {
    protected final MigrationVersion version;
    protected final String location;
    private String type;

    LocalMigrationResource(MigrationVersion version, String location) {
        this.version = version;
        this.location = location;
        this.type = version.type();
    }

    public String toString() {
        return this.version.toString();
    }

    boolean isRepeatable() {
        return this.version.isRepeatable();
    }

    boolean isRepeatableInit() {
        return this.version.isRepeatableInit();
    }

    boolean isRepeatableLast() {
        return this.version.isRepeatableLast();
    }

    @Override
    public String key() {
        if (this.isRepeatable()) {
            return this.version.comment().toLowerCase();
        }
        return this.version.normalised();
    }

    @Override
    public String comment() {
        String comment = this.version.comment();
        return comment == null || comment.isEmpty() ? "-" : comment;
    }

    @Override
    public int compareTo(MigrationResource other) {
        return this.version.compareTo(other.version());
    }

    @Override
    public MigrationVersion version() {
        return this.version;
    }

    @Override
    public String location() {
        return this.location;
    }

    @Override
    public String type() {
        return this.type;
    }

    void setInitType() {
        this.type = "B";
    }
}

