/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.migration.runner;

import io.avaje.applog.AppLog;
import io.ebean.migration.MigrationConfig;
import io.ebean.migration.MigrationContext;
import io.ebean.migration.MigrationException;
import io.ebean.migration.MigrationResource;
import io.ebean.migration.runner.DbNameUtil;
import io.ebean.migration.runner.DefaultMigrationContext;
import io.ebean.migration.runner.FirstCheck;
import io.ebean.migration.runner.LocalMigrationResource;
import io.ebean.migration.runner.LocalMigrationResources;
import io.ebean.migration.runner.MigrationPlatform;
import io.ebean.migration.runner.MigrationTable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;

public class MigrationEngine {
    static final System.Logger log = AppLog.getLogger((String)"io.ebean.migration");
    private final MigrationConfig migrationConfig;
    private final boolean checkStateOnly;
    private final boolean fastMode;

    public MigrationEngine(MigrationConfig migrationConfig, boolean checkStateOnly) {
        this.migrationConfig = migrationConfig;
        this.checkStateOnly = checkStateOnly;
        this.fastMode = !checkStateOnly && migrationConfig.isFastMode();
    }

    public List<MigrationResource> run(Connection connection) {
        try {
            List<MigrationResource> list = this.run(new DefaultMigrationContext(this.migrationConfig, connection));
            return list;
        }
        finally {
            this.close(connection);
        }
    }

    public List<MigrationResource> run(MigrationContext context) {
        long startMs = System.currentTimeMillis();
        LocalMigrationResources resources = new LocalMigrationResources(this.migrationConfig);
        if (!resources.readResources() && !resources.readInitResources()) {
            log.log(System.Logger.Level.DEBUG, "no migrations to check");
            return Collections.emptyList();
        }
        Connection connection = context.connection();
        long splitMs = System.currentTimeMillis() - startMs;
        MigrationPlatform platform = this.derivePlatform(this.migrationConfig, connection);
        FirstCheck firstCheck = new FirstCheck(this.migrationConfig, context, platform);
        if (this.fastMode && firstCheck.fastModeCheck(resources.versions())) {
            long checkMs = System.currentTimeMillis() - startMs;
            log.log(System.Logger.Level.INFO, "DB migrations completed in {0}ms - totalMigrations:{1} readResources:{2}ms", checkMs, firstCheck.count(), splitMs);
            return Collections.emptyList();
        }
        MigrationEngine.setAutoCommitFalse(connection);
        MigrationTable table = this.initialiseMigrationTable(firstCheck, connection);
        try {
            List<MigrationResource> result = this.runMigrations(table, resources.versions());
            connection.commit();
            if (!this.checkStateOnly) {
                long commitMs = System.currentTimeMillis();
                log.log(System.Logger.Level.INFO, "DB migrations completed in {0}ms - executed:{1} totalMigrations:{2} mode:{3}", commitMs - startMs, table.count(), table.size(), table.mode());
                int countNonTransactional = table.runNonTransactional();
                if (countNonTransactional > 0) {
                    log.log(System.Logger.Level.INFO, "Non-transactional DB migrations completed in {0}ms - executed:{1}", System.currentTimeMillis() - commitMs, countNonTransactional);
                }
            }
            List<MigrationResource> list = result;
            return list;
        }
        catch (MigrationException e) {
            MigrationEngine.rollback(connection);
            throw e;
        }
        catch (Throwable e) {
            log.log(System.Logger.Level.ERROR, "Perform rollback due to DB migration error", e);
            MigrationEngine.rollback(connection);
            throw new MigrationException("Error running DB migrations", e);
        }
        finally {
            table.unlockMigrationTable();
        }
    }

    private static void setAutoCommitFalse(Connection connection) {
        try {
            connection.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new MigrationException("Error running DB migrations", e);
        }
    }

    private MigrationTable initialiseMigrationTable(FirstCheck firstCheck, Connection connection) {
        try {
            MigrationTable table = firstCheck.initTable(this.checkStateOnly);
            table.createIfNeededAndLock();
            return table;
        }
        catch (Throwable e) {
            MigrationEngine.rollback(connection);
            throw new MigrationException("Error initialising db migrations table", e);
        }
    }

    private List<MigrationResource> runMigrations(MigrationTable table, List<LocalMigrationResource> localVersions) throws SQLException {
        LocalMigrationResource initVersion;
        if (table.isEmpty() && (initVersion = this.lastInitVersion()) != null) {
            log.log(System.Logger.Level.INFO, "dbinit migration version:{0}  local migrations:{1}  checkState:{2}", initVersion, localVersions.size(), this.checkStateOnly);
            return table.runInit(initVersion, localVersions);
        }
        return table.runAll(localVersions);
    }

    private LocalMigrationResource lastInitVersion() {
        List<LocalMigrationResource> initVersions;
        LocalMigrationResources initResources = new LocalMigrationResources(this.migrationConfig);
        if (initResources.readInitResources() && !(initVersions = initResources.versions()).isEmpty()) {
            return initVersions.get(initVersions.size() - 1);
        }
        return null;
    }

    private MigrationPlatform derivePlatform(MigrationConfig migrationConfig, Connection connection) {
        String platform = migrationConfig.getPlatform();
        if (platform != null) {
            return DbNameUtil.platform(platform);
        }
        String derivedPlatformName = DbNameUtil.normalise(connection);
        migrationConfig.setPlatform(derivedPlatformName);
        return DbNameUtil.platform(derivedPlatformName);
    }

    private void close(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException e) {
            log.log(System.Logger.Level.WARNING, "Error closing connection", (Throwable)e);
        }
    }

    static void rollback(Connection connection) {
        try {
            if (connection != null) {
                connection.rollback();
            }
        }
        catch (SQLException e) {
            log.log(System.Logger.Level.WARNING, "Error on connection rollback", (Throwable)e);
        }
    }
}

