/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.migration.runner;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;

class MigrationMetaRow {
    private final int id;
    private final String type;
    private final String version;
    private final String comment;
    private int checksum;
    private Timestamp runOn;
    private String runBy;
    private long runTime;

    MigrationMetaRow(int id, String type, String version, String comment, int checksum, String runBy, Timestamp runOn, long runTime) {
        this.id = id;
        this.type = type;
        this.version = version;
        this.checksum = checksum;
        this.comment = comment;
        this.runBy = runBy;
        this.runOn = runOn;
        this.runTime = runTime;
    }

    MigrationMetaRow(ResultSet row) throws SQLException {
        this.id = row.getInt(1);
        this.type = row.getString(2);
        this.version = row.getString(4);
        this.comment = row.getString(5);
        this.checksum = row.getInt(6);
        this.runOn = row.getTimestamp(7);
        this.runBy = row.getString(8);
        this.runTime = row.getLong(9);
    }

    public String toString() {
        return "id:" + this.id + " type:" + this.type + " runVersion:" + this.version + " comment:" + this.comment + " runOn:" + this.runOn + " runBy:" + this.runBy;
    }

    int getId() {
        return this.id;
    }

    String getVersion() {
        return this.version;
    }

    int getChecksum() {
        return this.checksum;
    }

    String getType() {
        return this.type;
    }

    private void bindInsert(PreparedStatement insert) throws SQLException {
        insert.setInt(1, this.id);
        insert.setString(2, this.type);
        insert.setString(3, "SUCCESS");
        insert.setString(4, this.version);
        insert.setString(5, this.comment);
        insert.setInt(6, this.checksum);
        insert.setTimestamp(7, this.runOn);
        insert.setString(8, this.runBy);
        insert.setLong(9, this.runTime);
    }

    private void bindUpdate(PreparedStatement update) throws SQLException {
        update.setInt(1, this.checksum);
        update.setTimestamp(2, this.runOn);
        update.setString(3, this.runBy);
        update.setLong(4, this.runTime);
        update.setInt(5, this.id);
    }

    static String insertSql(String table) {
        return "insert into " + table + " (id, mtype, mstatus, mversion, mcomment, mchecksum, run_on, run_by, run_time) values (?,?,?,?,?,?,?,?,?)";
    }

    static String updateSql(String table) {
        return "update " + table + " set mchecksum=?, run_on=?, run_by=?, run_time=?  where id = ?";
    }

    static String updateChecksumSql(String table) {
        return "update " + table + " set mchecksum=? where id = ?";
    }

    void rerun(int checksum, long exeMillis, String envUserName, Timestamp runOn) {
        this.checksum = checksum;
        this.runTime = exeMillis;
        this.runBy = envUserName;
        this.runOn = runOn;
    }

    void executeUpdate(Connection connection, String updateSql) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement(updateSql);){
            this.bindUpdate(statement);
            statement.executeUpdate();
        }
    }

    void executeInsert(Connection connection, String insertSql) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement(insertSql);){
            this.bindInsert(statement);
            statement.executeUpdate();
        }
    }

    void resetChecksum(int newChecksum, Connection connection, String updateChecksumSql) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement(updateChecksumSql);){
            statement.setInt(1, newChecksum);
            statement.setInt(2, this.id);
            statement.executeUpdate();
        }
    }
}

