/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.migration.runner;

import io.ebean.ddlrunner.DdlDetect;
import io.ebean.migration.runner.MigrationMetaRow;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationPlatform {
    private static final Logger log = LoggerFactory.getLogger((String)"io.ebean.DDL");
    private static final String BASE_SELECT_ID = "select id from ";
    private static final String BASE_SELECT_ALL = "select id, mtype, mstatus, mversion, mcomment, mchecksum, run_on, run_by, run_time from ";
    String forUpdateSuffix = " order by id for update";

    DdlDetect ddlDetect() {
        return DdlDetect.NONE;
    }

    void unlockMigrationTable(String sqlTable, Connection connection) throws SQLException {
    }

    void lockMigrationTable(String sqlTable, Connection connection) throws SQLException {
        for (int attempt = 0; attempt < 5; ++attempt) {
            if (this.lockRows(sqlTable, connection) > 0) {
                return;
            }
            MigrationPlatform.backoff(attempt);
        }
        throw new IllegalStateException("Failed to obtain row locks on migration table due to it being empty?");
    }

    private static void backoff(int attempt) {
        try {
            if (attempt % 100 == 0) {
                log.warn("In backoff loop attempting to obtain lock on DBMigration table ...");
            } else {
                log.trace("in backoff loop obtaining lock...");
            }
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while trying to obtain lock on migration table", e);
        }
    }

    private int lockRows(String sqlTable, Connection connection) throws SQLException {
        int rowCount = 0;
        String selectSql = this.sqlSelectForUpdate(sqlTable);
        try (PreparedStatement query = connection.prepareStatement(selectSql);
             ResultSet resultSet = query.executeQuery();){
            while (resultSet.next()) {
                resultSet.getInt(1);
                ++rowCount;
            }
        }
        return rowCount;
    }

    @Nonnull
    List<MigrationMetaRow> readExistingMigrations(String sqlTable, Connection connection) throws SQLException {
        String selectSql = this.sqlSelectForReading(sqlTable);
        ArrayList<MigrationMetaRow> rows = new ArrayList<MigrationMetaRow>();
        try (PreparedStatement query = connection.prepareStatement(selectSql);
             ResultSet resultSet = query.executeQuery();){
            while (resultSet.next()) {
                rows.add(new MigrationMetaRow(resultSet));
            }
        }
        return rows;
    }

    @Nonnull
    String sqlSelectForUpdate(String table) {
        return BASE_SELECT_ID + table + this.forUpdateSuffix;
    }

    @Nonnull
    String sqlSelectForReading(String table) {
        return BASE_SELECT_ALL + table + this.forUpdateSuffix;
    }

    public static class NoLocking
    extends MigrationPlatform {
        public NoLocking() {
            this.forUpdateSuffix = " order by id";
        }

        @Override
        void lockMigrationTable(String sqlTable, Connection connection) {
        }
    }

    public static class SqlServer
    extends MigrationPlatform {
        public SqlServer() {
            this.forUpdateSuffix = " with (updlock) order by id";
        }
    }

    public static class MySql
    extends MigrationPlatform {
        @Override
        void lockMigrationTable(String sqlTable, Connection connection) throws SQLException {
            int attempts = 0;
            while (!this.obtainNamedLock(connection)) {
                MigrationPlatform.backoff(++attempts);
            }
        }

        private boolean obtainNamedLock(Connection connection) throws SQLException {
            String hash = Integer.toHexString(connection.getMetaData().getURL().hashCode());
            try (PreparedStatement query = connection.prepareStatement("select get_lock('ebean_migration-" + hash + "', 10)");
                 ResultSet resultSet = query.executeQuery();){
                if (resultSet.next()) {
                    boolean bl = resultSet.getInt(1) == 1;
                    return bl;
                }
            }
            return false;
        }

        @Override
        void unlockMigrationTable(String sqlTable, Connection connection) throws SQLException {
            String hash = Integer.toHexString(connection.getMetaData().getURL().hashCode());
            try (PreparedStatement query = connection.prepareStatement("select release_lock('ebean_migration-" + hash + "')");){
                query.execute();
            }
        }
    }

    public static class Postgres
    extends MigrationPlatform {
        @Override
        DdlDetect ddlDetect() {
            return DdlDetect.POSTGRES;
        }

        @Override
        void lockMigrationTable(String sqlTable, Connection connection) throws SQLException {
            try (PreparedStatement query = connection.prepareStatement("lock table " + sqlTable);){
                query.execute();
            }
        }
    }

    public static class LogicalLock
    extends MigrationPlatform {
        @Override
        void lockMigrationTable(String sqlTable, Connection connection) throws SQLException {
            int attempts = 0;
            while (!this.obtainLogicalLock(sqlTable, connection)) {
                MigrationPlatform.backoff(++attempts);
            }
            log.trace("obtained logical lock");
        }

        @Override
        void unlockMigrationTable(String sqlTable, Connection connection) throws SQLException {
            this.releaseLogicalLock(sqlTable, connection);
            connection.commit();
        }

        private boolean obtainLogicalLock(String sqlTable, Connection connection) throws SQLException {
            try (PreparedStatement query = connection.prepareStatement("update " + sqlTable + " set mcomment=? where id=? and mcomment=?");){
                query.setString(1, "locked");
                query.setInt(2, 0);
                query.setString(3, "<init>");
                if (query.executeUpdate() == 1) {
                    connection.commit();
                    boolean bl = true;
                    return bl;
                }
                connection.rollback();
                boolean bl = false;
                return bl;
            }
        }

        private void releaseLogicalLock(String sqlTable, Connection connection) throws SQLException {
            String sql = "update " + sqlTable + " set mcomment='<init>' where id=0";
            try (PreparedStatement query = connection.prepareStatement(sql);){
                if (query.executeUpdate() != 1) {
                    log.error("Failed to release logical lock. Please review why [" + sql + "] didn't update the row?");
                } else {
                    log.trace("released logical lock");
                }
            }
        }
    }
}

