/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.migration.runner;

import io.ebean.ddlrunner.DdlRunner;
import io.ebean.migration.runner.MigrationPlatform;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

class MigrationScriptRunner {
    private final Connection connection;
    private final MigrationPlatform platform;
    private final List<String> nonTransactional = new ArrayList<String>();

    MigrationScriptRunner(Connection connection, MigrationPlatform platform) {
        this.connection = connection;
        this.platform = platform;
    }

    void runScript(String content, String scriptName) throws SQLException {
        DdlRunner runner = new DdlRunner(false, scriptName, this.platform.ddlDetect());
        this.nonTransactional.addAll(runner.runAll(content, this.connection));
    }

    public void runNonTransactional() {
        if (!this.nonTransactional.isEmpty()) {
            DdlRunner runner = new DdlRunner(false, "Non-transactional DDL", this.platform.ddlDetect());
            runner.runNonTransactional(this.connection, this.nonTransactional);
        }
    }
}

