/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.platform.db2;

import io.ebean.BackgroundExecutor;
import io.ebean.Query;
import io.ebean.annotation.Platform;
import io.ebean.config.dbplatform.AnsiSqlRowsLimiter;
import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebean.config.dbplatform.DbPlatformType;
import io.ebean.config.dbplatform.DbType;
import io.ebean.config.dbplatform.PlatformIdGenerator;
import io.ebean.config.dbplatform.SqlErrorCodes;
import io.ebean.platform.db2.DB2HistorySupport;
import io.ebean.platform.db2.DB2SequenceIdGenerator;
import javax.sql.DataSource;

public abstract class BaseDB2Platform
extends DatabasePlatform {
    public BaseDB2Platform() {
        this.platform = Platform.DB2;
        this.supportsNativeJavaTime = false;
        this.truncateTable = "truncate table %s reuse storage ignore delete triggers immediate";
        this.likeClauseRaw = "like ?";
        this.sqlLimiter = new AnsiSqlRowsLimiter();
        this.dbIdentity.setSupportsGetGeneratedKeys(true);
        this.dbIdentity.setSupportsSequence(true);
        this.idInExpandedForm = true;
        this.exceptionTranslator = new SqlErrorCodes().addAcquireLock(new String[]{"40001", "57033"}).addDuplicateKey(new String[]{"23505"}).addDataIntegrity(new String[]{"23502", "23503", "23504", "23511", "23512", "23511", "42917", "23515"}).build();
        this.historySupport = new DB2HistorySupport();
        this.booleanDbType = 16;
        this.dbTypeMap.put(DbType.VARCHAR, new DbPlatformType("varchar", 255, 4000, this.dbTypeMap.get(DbType.CLOB)));
        this.dbTypeMap.put(DbType.VARBINARY, new DbPlatformType("varbinary", 255, 8000, this.dbTypeMap.get(DbType.BLOB)));
        this.dbTypeMap.put(DbType.TINYINT, new DbPlatformType("smallint", false));
        this.dbTypeMap.put(DbType.INTEGER, new DbPlatformType("integer", false));
        this.dbTypeMap.put(DbType.BIGINT, new DbPlatformType("bigint", false));
        this.dbTypeMap.put(DbType.REAL, new DbPlatformType("real"));
        this.dbTypeMap.put(DbType.DECIMAL, new DbPlatformType("decimal", 16, 3));
    }

    public PlatformIdGenerator createSequenceIdGenerator(BackgroundExecutor be, DataSource ds, int stepSize, String seqName) {
        return new DB2SequenceIdGenerator(be, ds, seqName, this.sequenceBatchSize);
    }

    protected String withForUpdate(String sql, Query.LockWait lockWait, Query.LockType lockType) {
        return sql + " with rs use and keep update locks";
    }
}

