/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.platform.h2;

import io.ebean.config.dbplatform.AbstractDbEncrypt;
import io.ebean.config.dbplatform.DbEncryptFunction;

public class H2DbEncrypt
extends AbstractDbEncrypt {
    public H2DbEncrypt() {
        this.varcharEncryptFunction = new H2VarcharFunction();
        this.dateEncryptFunction = new H2DateFunction();
    }

    public boolean isBindEncryptDataFirst() {
        return false;
    }

    private static class H2DateFunction
    implements DbEncryptFunction {
        private H2DateFunction() {
        }

        public String getDecryptSql(String columnWithTableAlias) {
            return "PARSEDATETIME(TRIM(CHAR(0) FROM UTF8TOSTRING(DECRYPT('AES', STRINGTOUTF8(?), " + columnWithTableAlias + "))),'yyyyMMdd')";
        }

        public String getEncryptBindSql() {
            return "ENCRYPT('AES', STRINGTOUTF8(?), STRINGTOUTF8(FORMATDATETIME(?,'yyyyMMdd')))";
        }
    }

    private static class H2VarcharFunction
    implements DbEncryptFunction {
        private H2VarcharFunction() {
        }

        public String getDecryptSql(String columnWithTableAlias) {
            return "TRIM(CHAR(0) FROM UTF8TOSTRING(DECRYPT('AES', STRINGTOUTF8(?), " + columnWithTableAlias + ")))";
        }

        public String getEncryptBindSql() {
            return "ENCRYPT('AES', STRINGTOUTF8(?), STRINGTOUTF8(?))";
        }
    }
}

