/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.platform.mysql;

import io.ebean.annotation.Platform;
import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebean.config.dbplatform.DatabasePlatformProvider;
import io.ebean.platform.mysql.MySql55Platform;
import io.ebean.platform.mysql.MySqlPlatform;
import java.sql.Connection;
import java.sql.DatabaseMetaData;

public class MySqlPlatformProvider
implements DatabasePlatformProvider {
    public String toString() {
        return "MySql";
    }

    public boolean match(String name) {
        return name.startsWith("mysql");
    }

    public DatabasePlatform create(String name) {
        if (name.equals("mysql")) {
            return new MySqlPlatform();
        }
        if (name.equals("mysql55")) {
            return new MySql55Platform();
        }
        throw new IllegalArgumentException("Unexpected MySql platform name " + name);
    }

    public boolean matchByProductName(String productName) {
        return productName.contains("mysql");
    }

    public DatabasePlatform create(int majorVersion, int minorVersion, DatabaseMetaData meta, Connection connection) {
        if (majorVersion <= 5 && minorVersion <= 5) {
            return new MySql55Platform();
        }
        return new MySqlPlatform();
    }

    public boolean matchPlatform(Platform platform) {
        return Platform.MYSQL.equals((Object)platform.base());
    }

    public DatabasePlatform create(Platform platform) {
        return platform == Platform.MYSQL55 ? new MySql55Platform() : new MySqlPlatform();
    }
}

