/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.platform.mysql;

import io.ebean.config.dbplatform.AbstractDbEncrypt;
import io.ebean.config.dbplatform.DbEncryptFunction;

public class MySqlDbEncrypt
extends AbstractDbEncrypt {
    public MySqlDbEncrypt() {
        this.varcharEncryptFunction = new MyVarcharFunction();
        this.dateEncryptFunction = new MyDateFunction();
    }

    private static class MyDateFunction
    implements DbEncryptFunction {
        private MyDateFunction() {
        }

        public String getDecryptSql(String columnWithTableAlias) {
            return "STR_TO_DATE(AES_DECRYPT(" + columnWithTableAlias + ",?),'%Y%d%m')";
        }

        public String getEncryptBindSql() {
            return "AES_ENCRYPT(DATE_FORMAT(?,'%Y%d%m'),?)";
        }
    }

    private static class MyVarcharFunction
    implements DbEncryptFunction {
        private MyVarcharFunction() {
        }

        public String getDecryptSql(String columnWithTableAlias) {
            return "CONVERT(AES_DECRYPT(" + columnWithTableAlias + ",?) USING UTF8)";
        }

        public String getEncryptBindSql() {
            return "AES_ENCRYPT(?,?)";
        }
    }
}

