/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.platform.nuodb;

import io.ebean.BackgroundExecutor;
import io.ebean.Query;
import io.ebean.annotation.Platform;
import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebean.config.dbplatform.DbPlatformType;
import io.ebean.config.dbplatform.DbType;
import io.ebean.config.dbplatform.IdType;
import io.ebean.config.dbplatform.PlatformIdGenerator;
import io.ebean.config.dbplatform.SqlErrorCodes;
import io.ebean.platform.nuodb.NuoDbHistorySupport;
import io.ebean.platform.nuodb.NuoDbSequence;
import javax.sql.DataSource;

public class NuoDbPlatform
extends DatabasePlatform {
    public NuoDbPlatform() {
        this.platform = Platform.NUODB;
        this.idInExpandedForm = true;
        this.supportsResultSetConcurrencyModeUpdatable = false;
        this.supportsDeleteTableAlias = true;
        this.likeClauseRaw = "like ?";
        this.historySupport = new NuoDbHistorySupport();
        this.dbIdentity.setIdType(IdType.IDENTITY);
        this.dbIdentity.setSupportsIdentity(true);
        this.dbIdentity.setSupportsSequence(true);
        this.dbIdentity.setSupportsGetGeneratedKeys(true);
        this.exceptionTranslator = new SqlErrorCodes().addDuplicateKey(new String[]{"23000"}).addSerializableConflict(new String[]{"40002"}).build();
        this.dbTypeMap.put(DbType.INTEGER, new DbPlatformType("integer", false));
    }

    public PlatformIdGenerator createSequenceIdGenerator(BackgroundExecutor be, DataSource ds, int stepSize, String seqName) {
        return new NuoDbSequence(be, ds, seqName, stepSize);
    }

    protected String withForUpdate(String sql, Query.LockWait lockWait, Query.LockType lockType) {
        switch (lockWait) {
            case NOWAIT: {
                return sql + " for update nowait";
            }
        }
        return sql + " for update";
    }
}

