/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.platform.oracle;

import io.ebean.BackgroundExecutor;
import io.ebean.Query;
import io.ebean.annotation.Platform;
import io.ebean.config.dbplatform.BasicSqlAnsiLimiter;
import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebean.config.dbplatform.DbPlatformType;
import io.ebean.config.dbplatform.DbType;
import io.ebean.config.dbplatform.IdType;
import io.ebean.config.dbplatform.PlatformIdGenerator;
import io.ebean.config.dbplatform.SqlErrorCodes;
import io.ebean.platform.oracle.OracleAnsiSqlRowsLimiter;
import io.ebean.platform.oracle.OracleDbEncrypt;
import io.ebean.platform.oracle.OracleDbHistorySupport;
import io.ebean.platform.oracle.OracleSequenceIdGenerator;
import javax.sql.DataSource;

public class OraclePlatform
extends DatabasePlatform {
    public OraclePlatform() {
        this.platform = Platform.ORACLE;
        this.supportsDeleteTableAlias = true;
        this.maxInBinding = 1000;
        this.maxTableNameLength = 30;
        this.maxConstraintNameLength = 30;
        this.dbEncrypt = new OracleDbEncrypt();
        this.sqlLimiter = new OracleAnsiSqlRowsLimiter();
        this.basicSqlLimiter = new BasicSqlAnsiLimiter();
        this.historySupport = new OracleDbHistorySupport();
        this.truncateTable = "truncate table %s cascade";
        this.dbIdentity.setIdType(IdType.IDENTITY);
        this.dbIdentity.setSupportsSequence(true);
        this.dbIdentity.setSupportsIdentity(true);
        this.dbIdentity.setSupportsGetGeneratedKeys(true);
        this.dbDefaultValue.setFalse("0");
        this.dbDefaultValue.setTrue("1");
        this.dbDefaultValue.setNow("current_timestamp");
        this.treatEmptyStringsAsNull = true;
        this.likeClauseRaw = "like ?";
        this.exceptionTranslator = new SqlErrorCodes().addDuplicateKey(new String[]{"1"}).addDataIntegrity(new String[]{"2291"}).addSerializableConflict(new String[]{"72000"}).build();
        this.openQuote = "\"";
        this.closeQuote = "\"";
        this.booleanDbType = 4;
        this.dbTypeMap.put(DbType.BOOLEAN, new DbPlatformType("number(1)"));
        this.dbTypeMap.put(DbType.INTEGER, new DbPlatformType("number", 10));
        this.dbTypeMap.put(DbType.BIGINT, new DbPlatformType("number", 19));
        this.dbTypeMap.put(DbType.REAL, new DbPlatformType("number", 19, 4));
        this.dbTypeMap.put(DbType.DOUBLE, new DbPlatformType("number", 19, 4));
        this.dbTypeMap.put(DbType.SMALLINT, new DbPlatformType("number", 5));
        this.dbTypeMap.put(DbType.TINYINT, new DbPlatformType("number", 3));
        this.dbTypeMap.put(DbType.DECIMAL, new DbPlatformType("number", 16, 3));
        this.dbTypeMap.put(DbType.VARCHAR, new DbPlatformType("varchar2", 255));
        this.dbTypeMap.put(DbType.LONGVARBINARY, new DbPlatformType("blob"));
        this.dbTypeMap.put(DbType.LONGVARCHAR, new DbPlatformType("clob"));
        this.dbTypeMap.put(DbType.VARBINARY, new DbPlatformType("raw", 255));
        this.dbTypeMap.put(DbType.BINARY, new DbPlatformType("raw", 255));
        this.dbTypeMap.put(DbType.TIME, new DbPlatformType("timestamp"));
    }

    public PlatformIdGenerator createSequenceIdGenerator(BackgroundExecutor be, DataSource ds, int stepSize, String seqName) {
        return new OracleSequenceIdGenerator(be, ds, seqName, this.sequenceBatchSize);
    }

    protected String withForUpdate(String sql, Query.LockWait lockWait, Query.LockType lockType) {
        switch (lockWait) {
            case SKIPLOCKED: {
                return sql + " for update skip locked";
            }
            case NOWAIT: {
                return sql + " for update nowait";
            }
        }
        return sql + " for update";
    }
}

