/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.typequery;

import io.avaje.lang.NonNullApi;
import io.avaje.lang.Nullable;
import io.ebean.CacheMode;
import io.ebean.CountDistinctOrder;
import io.ebean.DB;
import io.ebean.Database;
import io.ebean.DtoQuery;
import io.ebean.Expression;
import io.ebean.ExpressionList;
import io.ebean.FetchConfig;
import io.ebean.FetchGroup;
import io.ebean.FetchPath;
import io.ebean.FutureIds;
import io.ebean.FutureList;
import io.ebean.FutureRowCount;
import io.ebean.InTuples;
import io.ebean.OrderBy;
import io.ebean.PagedList;
import io.ebean.Paging;
import io.ebean.PersistenceContextScope;
import io.ebean.ProfileLocation;
import io.ebean.Query;
import io.ebean.QueryIterator;
import io.ebean.RawSql;
import io.ebean.Transaction;
import io.ebean.UpdateQuery;
import io.ebean.Version;
import io.ebean.service.SpiFetchGroupQuery;
import io.ebean.typequery.IQueryBean;
import io.ebean.typequery.TQProperty;
import io.ebeaninternal.api.SpiQueryFetch;
import io.ebeaninternal.server.util.ArrayStack;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;

@NonNullApi
public abstract class QueryBean<T, R>
implements IQueryBean<T, R> {
    private final Query<T> query;
    private final R root;
    private ArrayStack<ExpressionList<T>> whereStack;

    protected QueryBean(Class<T> beanType) {
        this(beanType, DB.getDefault());
    }

    protected QueryBean(Class<T> beanType, Database database) {
        this(database.find(beanType));
    }

    protected QueryBean(Class<T> beanType, Transaction transaction) {
        this(beanType);
        this.query.usingTransaction(transaction);
    }

    protected QueryBean(Class<T> beanType, Database database, Transaction transaction) {
        this(beanType, database);
        this.query.usingTransaction(transaction);
    }

    protected QueryBean(Query<T> query) {
        this.query = query;
        this.root = this;
    }

    protected QueryBean(boolean aliasDummy) {
        this.query = null;
        this.root = this;
    }

    protected QueryBean(ExpressionList<T> filter) {
        this.query = null;
        this.root = null;
        this.whereStack = new ArrayStack();
        this.whereStack.push(filter);
    }

    protected void setRoot(R root) {
    }

    @Override
    public FetchGroup<T> buildFetchGroup() {
        return ((SpiFetchGroupQuery)this.query()).buildFetchGroup();
    }

    @Override
    public Query<T> query() {
        return this.query;
    }

    public R distinctOn(String distinctOn) {
        this.query.distinctOn(distinctOn);
        return this.root;
    }

    public R select(String properties) {
        this.query.select(properties);
        return this.root;
    }

    public R select(FetchGroup<T> fetchGroup) {
        this.query.select(fetchGroup);
        return this.root;
    }

    @Override
    @SafeVarargs
    public final R distinctOn(TQProperty<R, ?> ... properties) {
        StringJoiner joiner = new StringJoiner(", ");
        for (TQProperty<R, ?> property : properties) {
            joiner.add(property.toString());
        }
        this.distinctOn(joiner.toString());
        return this.root;
    }

    @Override
    @SafeVarargs
    public final R select(TQProperty<R, ?> ... properties) {
        ((SpiQueryFetch)this.query).selectProperties(this.properties(properties));
        return this.root;
    }

    private Set<String> properties(Query.Property<?>[] properties) {
        LinkedHashSet<String> props = new LinkedHashSet<String>();
        for (Query.Property<?> property : properties) {
            props.add(property.toString());
        }
        return props;
    }

    @Override
    public final R select(Query.Property<?> ... properties) {
        ((SpiQueryFetch)this.query).selectProperties(this.properties(properties));
        return this.root;
    }

    public final R fetch(String path) {
        this.query.fetch(path);
        return this.root;
    }

    public final R fetchQuery(String path) {
        this.query.fetchQuery(path);
        return this.root;
    }

    public final R fetchCache(String path) {
        this.query.fetchCache(path);
        return this.root;
    }

    public final R fetchQuery(String path, String properties) {
        this.query.fetchQuery(path, properties);
        return this.root;
    }

    public final R fetchCache(String path, String properties) {
        this.query.fetchCache(path, properties);
        return this.root;
    }

    public final R fetch(String path, String properties) {
        this.query.fetch(path, properties);
        return this.root;
    }

    public final R fetch(String path, String properties, FetchConfig fetchConfig) {
        this.query.fetch(path, properties, fetchConfig);
        return this.root;
    }

    public final R fetch(String path, FetchConfig fetchConfig) {
        this.query.fetch(path, fetchConfig);
        return this.root;
    }

    public R fetchLazy(String path, String fetchProperties) {
        this.query.fetchLazy(path, fetchProperties);
        return this.root;
    }

    public R fetchLazy(String path) {
        this.query.fetchLazy(path);
        return this.root;
    }

    public final R apply(FetchPath pathProperties) {
        this.query.apply(pathProperties);
        return this.root;
    }

    public final R also(Consumer<R> apply) {
        apply.accept(this.root);
        return this.root;
    }

    public final R alsoIf(BooleanSupplier predicate, Consumer<R> apply) {
        if (predicate.getAsBoolean()) {
            apply.accept(this.root);
        }
        return this.root;
    }

    public final R asOf(Timestamp asOf) {
        this.query.asOf(asOf);
        return this.root;
    }

    public final R setIncludeSoftDeletes() {
        this.query.setIncludeSoftDeletes();
        return this.root;
    }

    @Override
    public final R add(Expression expression) {
        this.peekExprList().add(expression);
        return this.root;
    }

    public final R alias(String alias) {
        this.query.alias(alias);
        return this.root;
    }

    public R setPaging(Paging paging) {
        this.query.setPaging(paging);
        return this.root;
    }

    public final R setMaxRows(int maxRows) {
        this.query.setMaxRows(maxRows);
        return this.root;
    }

    public final R setFirstRow(int firstRow) {
        this.query.setFirstRow(firstRow);
        return this.root;
    }

    public final R setAllowLoadErrors() {
        this.query.setAllowLoadErrors();
        return this.root;
    }

    public final R setAutoTune(boolean autoTune) {
        this.query.setAutoTune(autoTune);
        return this.root;
    }

    public final R setBufferFetchSizeHint(int fetchSize) {
        this.query.setBufferFetchSizeHint(fetchSize);
        return this.root;
    }

    public final R setDistinct(boolean distinct) {
        this.query.setDistinct(distinct);
        return this.root;
    }

    public final R setBaseTable(String baseTable) {
        this.query.setBaseTable(baseTable);
        return this.root;
    }

    public final R withLock(Query.LockType lockType) {
        this.query.withLock(lockType);
        return this.root;
    }

    public final R withLock(Query.LockType lockType, Query.LockWait lockWait) {
        this.query.withLock(lockType, lockWait);
        return this.root;
    }

    @Override
    public final R exists(Query<?> subQuery) {
        this.peekExprList().exists(subQuery);
        return this.root;
    }

    @Override
    public final R notExists(Query<?> subQuery) {
        this.peekExprList().notExists(subQuery);
        return this.root;
    }

    @Override
    public final R exists(String sqlSubQuery, Object ... bindValues) {
        this.peekExprList().exists(sqlSubQuery, bindValues);
        return this.root;
    }

    @Override
    public final R notExists(String sqlSubQuery, Object ... bindValues) {
        this.peekExprList().notExists(sqlSubQuery, bindValues);
        return this.root;
    }

    public final R forUpdate() {
        this.query.forUpdate();
        return this.root;
    }

    public final R forUpdateNoWait() {
        this.query.forUpdateNoWait();
        return this.root;
    }

    public final R forUpdateSkipLocked() {
        this.query.forUpdateSkipLocked();
        return this.root;
    }

    public final UpdateQuery<T> asUpdate() {
        return this.query.asUpdate();
    }

    public final <D> DtoQuery<D> asDto(Class<D> dtoClass) {
        return this.query.asDto(dtoClass);
    }

    @Override
    public final R setId(Object id) {
        this.query.setId(id);
        return this.root;
    }

    @Override
    public final R setIdIn(Object ... ids) {
        this.query.where().idIn(ids);
        return this.root;
    }

    @Override
    public final R setIdIn(Collection<?> ids) {
        this.query.where().idIn(ids);
        return this.root;
    }

    public final R setLabel(String label) {
        this.query.setLabel(label);
        return this.root;
    }

    public final R setHint(String hint) {
        this.query.setHint(hint);
        return this.root;
    }

    @Override
    public final R setProfileLocation(ProfileLocation profileLocation) {
        this.query.setProfileLocation(profileLocation);
        return this.root;
    }

    public final R setLazyLoadBatchSize(int lazyLoadBatchSize) {
        this.query.setLazyLoadBatchSize(lazyLoadBatchSize);
        return this.root;
    }

    public final R setMapKey(String mapKey) {
        this.query.setMapKey(mapKey);
        return this.root;
    }

    public final R setPersistenceContextScope(PersistenceContextScope scope) {
        this.query.setPersistenceContextScope(scope);
        return this.root;
    }

    public R setCountDistinct(CountDistinctOrder orderBy) {
        this.query.setCountDistinct(orderBy);
        return this.root;
    }

    public final R setRawSql(RawSql rawSql) {
        this.query.setRawSql(rawSql);
        return this.root;
    }

    public final R setReadOnly(boolean readOnly) {
        this.query.setReadOnly(readOnly);
        return this.root;
    }

    public final R setBeanCacheMode(CacheMode beanCacheMode) {
        this.query.setBeanCacheMode(beanCacheMode);
        return this.root;
    }

    public final R setDisableLazyLoading(boolean disableLazyLoading) {
        this.query.setDisableLazyLoading(disableLazyLoading);
        return this.root;
    }

    public final R setUseQueryCache(CacheMode cacheMode) {
        this.query.setUseQueryCache(cacheMode);
        return this.root;
    }

    public final R setTimeout(int secs) {
        this.query.setTimeout(secs);
        return this.root;
    }

    public final Set<String> validate() {
        return this.query.validate();
    }

    @Override
    public final R raw(String rawExpression) {
        this.peekExprList().raw(rawExpression);
        return this.root;
    }

    @Override
    public final R raw(String rawExpression, Object ... bindValues) {
        this.peekExprList().raw(rawExpression, bindValues);
        return this.root;
    }

    @Override
    public final R rawOrEmpty(String raw, Collection<?> values) {
        this.peekExprList().rawOrEmpty(raw, values);
        return this.root;
    }

    @Override
    public final R raw(String rawExpression, Object bindValue) {
        this.peekExprList().raw(rawExpression, bindValue);
        return this.root;
    }

    @Override
    public final R inTuples(InTuples inTuples) {
        this.peekExprList().inTuples(inTuples);
        return this.root;
    }

    @Override
    public final R orderBy() {
        return this.root;
    }

    @Override
    @Deprecated(since="13.19", forRemoval=true)
    public final R order() {
        return this.root;
    }

    public final R orderBy(String orderByClause) {
        this.query.orderBy(orderByClause);
        return this.root;
    }

    public R setOrderBy(OrderBy<T> orderBy) {
        this.query.setOrderBy(orderBy);
        return this.root;
    }

    public R orderById(boolean orderById) {
        this.query.orderById(orderById);
        return this.root;
    }

    @Override
    @Deprecated(since="13.19", forRemoval=true)
    public final R order(String orderByClause) {
        return this.orderBy(orderByClause);
    }

    @Override
    public final R or() {
        this.pushExprList((ExpressionList<T>)this.peekExprList().or());
        return this.root;
    }

    @Override
    public final R and() {
        this.pushExprList((ExpressionList<T>)this.peekExprList().and());
        return this.root;
    }

    @Override
    public final R not() {
        this.pushExprList((ExpressionList<T>)this.peekExprList().not());
        return this.root;
    }

    @Override
    public final R endJunction() {
        this.whereStack.pop();
        return this.root;
    }

    @Override
    public final R endOr() {
        return this.endJunction();
    }

    @Override
    public final R endAnd() {
        return this.endJunction();
    }

    @Override
    public final R endNot() {
        return this.endJunction();
    }

    private R pushExprList(ExpressionList<T> list) {
        this.whereStack.push(list);
        return this.root;
    }

    @Override
    public final R where() {
        return this.root;
    }

    public final R usingTransaction(Transaction transaction) {
        this.query.usingTransaction(transaction);
        return this.root;
    }

    public final R usingConnection(Connection connection) {
        this.query.usingConnection(connection);
        return this.root;
    }

    public R usingDatabase(Database database) {
        this.query.usingDatabase(database);
        return this.root;
    }

    public final R usingMaster() {
        this.query.usingMaster();
        return this.root;
    }

    public final boolean exists() {
        return this.query.exists();
    }

    @Nullable
    public final T findOne() {
        return (T)this.query.findOne();
    }

    public final Optional<T> findOneOrEmpty() {
        return this.query.findOneOrEmpty();
    }

    public final List<T> findList() {
        return this.query.findList();
    }

    public final Stream<T> findStream() {
        return this.query.findStream();
    }

    public final Set<T> findSet() {
        return this.query.findSet();
    }

    public final <A> List<A> findIds() {
        return this.query.findIds();
    }

    public final <K> Map<K, T> findMap() {
        return this.query.findMap();
    }

    public final QueryIterator<T> findIterate() {
        return this.query.findIterate();
    }

    public final <A> List<A> findSingleAttributeList() {
        return this.query.findSingleAttributeList();
    }

    public final <A> Set<A> findSingleAttributeSet() {
        return this.query.findSingleAttributeSet();
    }

    @Nullable
    public final <A> A findSingleAttribute() {
        return (A)this.query.findSingleAttribute();
    }

    public final <A> Optional<A> findSingleAttributeOrEmpty() {
        return this.query.findSingleAttributeOrEmpty();
    }

    public final void findEach(Consumer<T> consumer) {
        this.query.findEach(consumer);
    }

    public final void findEach(int batch, Consumer<List<T>> consumer) {
        this.query.findEach(batch, consumer);
    }

    public final void findEachWhile(Predicate<T> consumer) {
        this.query.findEachWhile(consumer);
    }

    public final List<Version<T>> findVersions() {
        return this.query.findVersions();
    }

    public final List<Version<T>> findVersionsBetween(Timestamp start, Timestamp end) {
        return this.query.findVersionsBetween(start, end);
    }

    public final int findCount() {
        return this.query.findCount();
    }

    public final FutureRowCount<T> findFutureCount() {
        return this.query.findFutureCount();
    }

    public final FutureIds<T> findFutureIds() {
        return this.query.findFutureIds();
    }

    public final FutureList<T> findFutureList() {
        return this.query.findFutureList();
    }

    public final PagedList<T> findPagedList() {
        return this.query.findPagedList();
    }

    public final int delete() {
        return this.query.delete();
    }

    public final String getGeneratedSql() {
        return this.query.getGeneratedSql();
    }

    public final Class<T> getBeanType() {
        return this.query.getBeanType();
    }

    @Override
    public final ExpressionList<T> getExpressionList() {
        return this.query.where();
    }

    @Override
    public final R having() {
        if (this.whereStack == null) {
            this.whereStack = new ArrayStack();
        }
        this.whereStack.push((Object)this.query.having());
        return this.root;
    }

    @Override
    public final ExpressionList<T> havingClause() {
        return this.query.having();
    }

    protected final ExpressionList<T> peekExprList() {
        if (this.whereStack == null) {
            this.whereStack = new ArrayStack();
            this.whereStack.push((Object)this.query.where());
        }
        return (ExpressionList)this.whereStack.peek();
    }
}

