/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.spring.txn;

import io.avaje.applog.AppLog;
import io.ebean.TxScope;
import io.ebean.config.ExternalTransactionManager;
import io.ebean.spring.txn.SpringJdbcTransaction;
import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.server.transaction.TransactionManager;
import java.util.List;
import javax.persistence.PersistenceException;
import javax.sql.DataSource;
import org.springframework.jdbc.datasource.ConnectionHolder;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public final class SpringJdbcTransactionManager
implements ExternalTransactionManager {
    private static final System.Logger log = AppLog.getLogger(SpringJdbcTransactionManager.class);
    private DataSource dataSource;
    private TransactionManager transactionManager;

    public void setTransactionManager(Object txnMgr) {
        this.transactionManager = (TransactionManager)txnMgr;
        this.dataSource = this.transactionManager.dataSource();
    }

    public Object getCurrentTransaction() {
        ConnectionHolder holder = (ConnectionHolder)TransactionSynchronizationManager.getResource((Object)this.dataSource);
        if (holder == null || !holder.isSynchronizedWithTransaction()) {
            SpiTransaction currentEbeanTransaction = this.transactionManager.inScope();
            if (currentEbeanTransaction == null || !currentEbeanTransaction.isActive()) {
                return null;
            }
            return currentEbeanTransaction;
        }
        SpringTxnListener springTxnLister = this.listener();
        if (springTxnLister != null) {
            return springTxnLister.transaction();
        }
        SpringJdbcTransaction newTrans = new SpringJdbcTransaction(holder, this.transactionManager);
        springTxnLister = this.createListener(newTrans);
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)springTxnLister);
        return this.transactionManager.externalBeginTransaction((SpiTransaction)newTrans, TxScope.required());
    }

    private SpringTxnListener listener() {
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            List synchronizations = TransactionSynchronizationManager.getSynchronizations();
            for (TransactionSynchronization synchronization : synchronizations) {
                if (!(synchronization instanceof SpringTxnListener)) continue;
                return (SpringTxnListener)synchronization;
            }
        }
        return null;
    }

    private SpringTxnListener createListener(SpringJdbcTransaction transaction) {
        return new SpringTxnListener(this.transactionManager, transaction);
    }

    private static class SpringTxnListener
    implements TransactionSynchronization {
        private final TransactionManager transactionManager;
        private final SpringJdbcTransaction transaction;

        private SpringTxnListener(TransactionManager transactionManager, SpringJdbcTransaction t) {
            this.transactionManager = transactionManager;
            this.transaction = t;
        }

        private SpringJdbcTransaction transaction() {
            return this.transaction;
        }

        public void flush() {
            this.transaction.flush();
        }

        public void beforeCommit(boolean readOnly) {
            if (!readOnly) {
                this.transaction.preCommit();
            }
        }

        public void afterCompletion(int status) {
            switch (status) {
                case 0: {
                    log.log(System.Logger.Level.DEBUG, "Spring Txn [{0}] committed", this.transaction.id());
                    this.transaction.postCommit();
                    break;
                }
                case 1: {
                    log.log(System.Logger.Level.DEBUG, "Spring Txn [{0}] rollback", this.transaction.id());
                    this.transaction.postRollback(null);
                    break;
                }
                default: {
                    throw new PersistenceException("Invalid status " + status);
                }
            }
            this.transactionManager.externalRemoveTransaction();
        }
    }
}

