/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.test.containers;

import io.ebean.test.containers.BaseConfig;
import io.ebean.test.containers.Commands;
import io.ebean.test.containers.Container;
import io.ebean.test.containers.ContainerConfig;
import io.ebean.test.containers.InternalConfig;
import io.ebean.test.containers.SkipShutdown;
import io.ebean.test.containers.StopMode;
import io.ebean.test.containers.process.ProcessHandler;
import io.ebean.test.containers.process.ProcessResult;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

abstract class BaseContainer
implements Container {
    static final System.Logger log = Commands.log;
    protected final BaseConfig<?, ?> buildConfig;
    protected InternalConfig config;
    protected final Commands commands;
    protected int waitForConnectivityAttempts = 200;
    protected StopMode shutdownMode;
    protected boolean usingContainerId;
    protected boolean usingRandomPort;
    protected boolean removeOnExit;
    private static final AtomicInteger hookCounter = new AtomicInteger();

    BaseContainer(BaseConfig<?, ?> buildConfig) {
        this.buildConfig = buildConfig;
        this.commands = new Commands(buildConfig.docker);
        this.config = buildConfig.internalConfig();
    }

    protected abstract ProcessBuilder runProcess();

    @Override
    public ContainerConfig config() {
        return this.config;
    }

    @Override
    public boolean start() {
        this.setDefaultContainerName();
        return this.shutdownHook(this.logStarted(this.startWithConnectivity()));
    }

    @Override
    public int port() {
        return this.config.getPort();
    }

    protected void setDefaultContainerName() {
        this.config.setDefaultContainerName();
        this.shutdownMode = this.determineShutdownMode();
    }

    private StopMode determineShutdownMode() {
        StopMode mode = this.config.shutdownMode();
        if (mode == StopMode.Auto) {
            if (this.config.randomPort()) {
                return StopMode.Stop;
            }
            if (SkipShutdown.isSkip()) {
                return StopMode.None;
            }
            return StopMode.Remove;
        }
        return mode;
    }

    @Override
    public boolean isRunning() {
        return this.commands.isRunning(this.config.containerName());
    }

    public void registerShutdownHook() {
        if (this.shutdownMode == StopMode.Stop || this.shutdownMode == StopMode.Remove) {
            Runtime.getRuntime().addShutdownHook(new Hook(this.shutdownMode));
        }
    }

    protected boolean shutdownHook(boolean started) {
        if (StopMode.None != this.config.shutdownMode()) {
            this.registerShutdownHook();
        }
        return started;
    }

    protected boolean startWithConnectivity() {
        this.startIfNeeded();
        if (!this.waitForConnectivity()) {
            log.log(System.Logger.Level.WARNING, "Container {0} failed to start - waiting for connectivity", this.config.containerName());
            return false;
        }
        return true;
    }

    boolean startIfNeeded() {
        boolean hasContainerName = this.hasContainerName();
        if (hasContainerName && this.commands.isRunning(this.config.containerName())) {
            this.checkPort(true);
            this.logRunning();
            return true;
        }
        if (hasContainerName && this.commands.isRegistered(this.config.containerName())) {
            this.checkPort(false);
            this.startContainer();
            this.logStart();
        } else {
            this.runContainer();
            this.logRun();
        }
        return false;
    }

    void startContainer() {
        this.commands.start(this.config.containerName());
    }

    private void checkPort(boolean isRunning) {
        String portBindings = this.commands.registeredPortMatch(this.config.containerName(), this.config.getPort());
        if (portBindings != null) {
            String msg = "The existing port bindings [" + portBindings + "] for this docker container [" + this.config.containerName() + "] don't match the configured port [" + this.config.getPort() + "] so it seems the port has changed? Maybe look to remove the container first if you want to use the new port via:";
            if (isRunning) {
                msg = msg + "    docker stop " + this.config.containerName();
            }
            msg = msg + "    docker rm " + this.config.containerName();
            throw new IllegalStateException(msg);
        }
    }

    void runContainer() {
        ProcessResult result = ProcessHandler.process(this.runProcess());
        if (log.isLoggable(System.Logger.Level.DEBUG)) {
            log.log(System.Logger.Level.DEBUG, "run output {0}", result.getOutLines());
        }
        if (!this.hasContainerName()) {
            this.usingContainerId = true;
            this.parseContainerId(result.getOutLines());
        }
        if (this.usingRandomPort) {
            this.obtainPort();
        }
    }

    private void parseContainerId(List<String> outLines) {
        if (outLines == null || outLines.isEmpty()) {
            throw new IllegalStateException("Expected docker run output to contain containerId but got [" + outLines + "]");
        }
        this.config.setContainerId(outLines.get(outLines.size() - 1).trim());
    }

    private void obtainPort() {
        int assignedPort = this.commands.port(this.config.containerName());
        if (assignedPort == 0) {
            throw new IllegalStateException("Unable to determine assigned port for containerId [" + this.config.containerName() + "]");
        }
        log.log(System.Logger.Level.DEBUG, "Container {0} using port {1,number,#}", this.config.containerName(), assignedPort);
        this.config.setAssignedPort(assignedPort);
    }

    boolean logsContain(String match, String clearMatch) {
        return this.logsContain(this.config.containerName(), match, clearMatch);
    }

    boolean logsContain(String containerName, String match, String clearMatch) {
        return this.commands.logsContain(containerName, match, clearMatch);
    }

    List<String> logs() {
        return this.commands.logs(this.config.containerName());
    }

    abstract boolean checkConnectivity();

    boolean waitForConnectivity() {
        log.log(System.Logger.Level.DEBUG, "waitForConnectivity {0} max attempts:{1} ... ", this.config.containerName(), this.waitForConnectivityAttempts);
        for (int i = 0; i < this.waitForConnectivityAttempts; ++i) {
            if (this.checkConnectivity()) {
                return true;
            }
            try {
                int sleep = i < 10 ? 10 : (i < 20 ? 20 : 200);
                Thread.sleep(sleep);
                if (i <= 200 || i % 100 != 0) continue;
                log.log(System.Logger.Level.INFO, "waitForConnectivity {0} attempts {1} of {2} ... ", this.config.containerName(), i, this.waitForConnectivityAttempts);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
        return false;
    }

    @Override
    public void stop() {
        this.stopIfRunning();
    }

    void stopIfRunning() {
        this.commands.stopIfRunning(this.config.containerName(), this.usingContainerId);
    }

    @Override
    public void stopRemove() {
        this.stopIfRunning();
        if (!this.removeOnExit) {
            this.commands.removeIfRegistered(this.config.containerName(), this.usingContainerId);
        }
    }

    protected ProcessBuilder createProcessBuilder(List<String> args) {
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.command(args);
        if (log.isLoggable(System.Logger.Level.DEBUG)) {
            log.log(System.Logger.Level.DEBUG, String.join((CharSequence)" ", args));
        }
        return pb;
    }

    protected List<String> dockerRun() {
        this.usingRandomPort = this.config.randomPort();
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.config.docker());
        args.add("run");
        args.add("-d");
        if (this.hasContainerName()) {
            args.add("--name");
            args.add(this.config.containerName());
        } else if (this.usingRandomPort) {
            this.removeOnExit = true;
            args.add("--rm");
        }
        if (this.usingRandomPort) {
            args.add("-p");
            args.add(String.valueOf(this.config.getInternalPort()));
        } else {
            args.add("-p");
            args.add(this.config.getPort() + ":" + this.config.getInternalPort());
        }
        return args;
    }

    boolean notEmpty(String value) {
        return value != null && !value.isEmpty();
    }

    boolean hasContainerName() {
        this.config.setDefaultContainerName();
        return this.notEmpty(this.config.containerName());
    }

    void logRunning() {
        log.log(System.Logger.Level.INFO, "Container {0} already running with host:{1} port:{2,number,#}", this.config.containerName(), this.config.getHost(), this.config.getPort());
    }

    void logRun() {
        log.log(System.Logger.Level.INFO, "Run container {0} with host:{1} port:{2,number,#} shutdownMode:{3}", this.logContainerName(), this.config.getHost(), this.config.getPort(), this.logContainerShutdown());
    }

    String logContainerShutdown() {
        return this.shutdownMode + (String)(this.usingContainerId ? " id:" + this.config.containerName() : "");
    }

    String logContainerName() {
        return this.usingContainerId ? this.config.image() : this.config.containerName();
    }

    void logStart() {
        log.log(System.Logger.Level.INFO, "Start container {0} with host:{1} port:{2,number,#}", this.config.containerName(), this.config.getHost(), this.config.getPort());
    }

    void logNotStarted() {
        log.log(System.Logger.Level.WARNING, "Failed to start container {0} with host:{1} port:{2,number,#}", this.config.containerName(), this.config.getHost(), this.config.getPort());
    }

    void logStarted() {
        log.log(System.Logger.Level.DEBUG, "Container {0} ready with host:{1} port:{2,number,#}", this.config.containerName(), this.config.getHost(), this.config.getPort());
    }

    boolean logStarted(boolean started) {
        if (!started) {
            this.logNotStarted();
        } else {
            this.logStarted();
        }
        return started;
    }

    protected String readUrlContent(String url) throws IOException {
        URLConnection yc = new URL(url).openConnection();
        StringBuilder sb = new StringBuilder(300);
        try (BufferedReader in = new BufferedReader(new InputStreamReader(yc.getInputStream(), StandardCharsets.UTF_8));){
            String inputLine;
            while ((inputLine = in.readLine()) != null) {
                sb.append(inputLine).append("\n");
            }
        }
        return sb.toString();
    }

    private class Hook
    extends Thread {
        private final StopMode mode;

        Hook(StopMode mode) {
            super("shutdown" + hookCounter.getAndIncrement());
            this.mode = mode;
        }

        @Override
        public void run() {
            if (StopMode.Remove == this.mode) {
                log.log(System.Logger.Level.INFO, "Stop remove container {0}", BaseContainer.this.config.containerName());
                BaseContainer.this.stopRemove();
            } else {
                log.log(System.Logger.Level.INFO, "Stop container {0}", BaseContainer.this.config.containerName());
                BaseContainer.this.stopIfRunning();
            }
        }
    }
}

