/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.test.containers;

import io.ebean.test.containers.BasePostgresContainer;
import io.ebean.test.containers.Container;
import io.ebean.test.containers.DbConfig;

public class PostgresContainer
extends BasePostgresContainer
implements Container {
    public static Builder builder(String version) {
        return new Builder(version);
    }

    @Deprecated
    public static Builder newBuilder(String version) {
        return PostgresContainer.builder(version);
    }

    private PostgresContainer(Builder config) {
        super(config);
    }

    public static class Builder
    extends DbConfig<PostgresContainer, Builder> {
        private Builder(String version) {
            super("postgres", 6432, 5432, version);
            this.adminUsername = "postgres";
            this.tmpfs = "/var/lib/postgresql/data:rw";
        }

        @Override
        protected String buildJdbcUrl() {
            return "jdbc:postgresql://" + this.host + ":" + this.port + "/" + this.dbName;
        }

        @Override
        protected String buildJdbcAdminUrl() {
            return "jdbc:postgresql://" + this.host + ":" + this.port + "/postgres";
        }

        @Override
        protected String buildExtraJdbcUrl() {
            return "jdbc:postgresql://" + this.host + ":" + this.port + "/" + this.extraDb;
        }

        @Override
        public PostgresContainer build() {
            return new PostgresContainer(this);
        }
    }
}

