/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.test.containers;

import io.ebean.test.containers.Commands;
import io.ebean.test.containers.Container;
import io.ebean.test.containers.DbConfig;
import io.ebean.test.containers.DbContainer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;

public class HanaContainer
extends DbContainer
implements Container {
    private static final System.Logger log = Commands.log;
    private final Builder hanaConfig;

    public HanaContainer start() {
        this.startOrThrow();
        return this;
    }

    public static Builder builder(String version) {
        return new Builder(version);
    }

    @Deprecated
    public static Builder newBuilder(String version) {
        return HanaContainer.builder(version);
    }

    public static boolean checkLicenseAgreement() {
        String propertyValue = System.getProperty("hana.agreeToSapLicense");
        if (propertyValue != null) {
            return Boolean.parseBoolean(propertyValue);
        }
        propertyValue = System.getenv("hana.agreeToSapLicense");
        if (propertyValue != null) {
            return Boolean.parseBoolean(propertyValue);
        }
        return false;
    }

    private HanaContainer(Builder builder) {
        super(builder);
        this.hanaConfig = builder;
        String osName = System.getProperty("os.name").toLowerCase();
        if (!osName.contains("linux")) {
            throw new IllegalStateException("The HANA docker image requires a Linux operating system");
        }
        if (!this.hanaConfig.isAgreeToSapLicense()) {
            throw new IllegalStateException("You must agree to the SAP license (https://www.sap.com/docs/download/cmp/2016/06/sap-hana-express-dev-agmt-and-exhibit.pdf) by setting the property 'hana.agreeToSapLicense' to 'true'");
        }
    }

    @Override
    protected boolean isDatabaseAdminReady() {
        return this.isDatabaseReady();
    }

    @Override
    protected boolean isDatabaseReady() {
        return this.commands.logsContain(this.config.containerName(), "Startup finished!");
    }

    @Override
    public boolean startWithCreate() {
        this.startIfNeeded();
        if (!this.waitForDatabaseReady()) {
            log.log(System.Logger.Level.WARNING, "Failed waitForDatabaseReady for container {0}", this.config.containerName());
            return false;
        }
        if (!this.createUserIfNotExists()) {
            return false;
        }
        if (!this.waitForConnectivity()) {
            log.log(System.Logger.Level.WARNING, "Failed waiting for connectivity");
            return false;
        }
        return true;
    }

    @Override
    public boolean startWithDropCreate() {
        this.startIfNeeded();
        if (!this.waitForDatabaseReady()) {
            log.log(System.Logger.Level.WARNING, "Failed waitForDatabaseReady for container {0}", this.config.containerName());
            return false;
        }
        this.dropUserIfExists();
        if (!this.createUserIfNotExists()) {
            return false;
        }
        if (!this.waitForConnectivity()) {
            log.log(System.Logger.Level.WARNING, "Failed waiting for connectivity");
            return false;
        }
        return true;
    }

    @Override
    protected ProcessBuilder runProcess() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.config.docker());
        args.add("run");
        args.add("-d");
        args.add("-p");
        args.add("3" + this.hanaConfig.getInstanceNumber() + "13:39013");
        args.add("-p");
        args.add(this.config.getPort() + ":" + this.config.getInternalPort());
        args.add("-p");
        args.add("3" + this.hanaConfig.getInstanceNumber() + "41-3" + this.hanaConfig.getInstanceNumber() + "45:39041-39045");
        args.add("-v");
        args.add(this.hanaConfig.getMountsDirectory() + ":/hana/mounts");
        args.add("--ulimit");
        args.add("nofile=1048576:1048576");
        args.add("--sysctl");
        args.add("kernel.shmmax=1073741824");
        args.add("--sysctl");
        args.add("kernel.shmmni=524288");
        args.add("--sysctl");
        args.add("kernel.shmall=8388608");
        args.add("--name");
        args.add(this.config.containerName());
        args.add(this.config.getImage());
        args.add("--passwords-url");
        args.add(this.hanaConfig.getPasswordsUrl().toString());
        if (this.hanaConfig.isAgreeToSapLicense()) {
            args.add("--agree-to-sap-license");
        }
        return this.createProcessBuilder(args);
    }

    private boolean dropUserIfExists() {
        log.log(System.Logger.Level.INFO, "Drop database user {0} if exists", this.dbConfig.getUsername());
        this.sqlProcess(connection -> {
            if (this.userExists((Connection)connection)) {
                this.sqlRun((Connection)connection, "drop user " + this.dbConfig.getUsername() + " cascade");
            }
        });
        return true;
    }

    private boolean createUserIfNotExists() {
        log.log(System.Logger.Level.INFO, "Create database user {0} if not exists", this.dbConfig.getUsername());
        this.sqlProcess(connection -> {
            if (!this.userExists((Connection)connection)) {
                this.sqlRun((Connection)connection, "create user " + this.dbConfig.getUsername() + " password " + this.dbConfig.getPassword() + " no force_first_password_change");
            }
        });
        return true;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean userExists(Connection connection) {
        try (PreparedStatement statement = connection.prepareStatement("select count(*) from sys.users where user_name = upper(?)");){
            boolean bl;
            block18: {
                ResultSet rs;
                block16: {
                    boolean bl2;
                    block17: {
                        statement.setString(1, this.dbConfig.getUsername());
                        rs = statement.executeQuery();
                        try {
                            if (!rs.next()) break block16;
                            int count = rs.getInt(1);
                            boolean bl3 = bl2 = count == 1;
                            if (rs == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return bl2;
                }
                bl = false;
                if (rs == null) break block18;
                rs.close();
            }
            return bl;
        }
        catch (SQLException e) {
            log.log(System.Logger.Level.ERROR, "Failed to execute sql to check if user exists", (Throwable)e);
            return false;
        }
    }

    private <E extends Throwable> void sneakyThrow(Throwable t) throws E {
        throw t;
    }

    public static class Builder
    extends DbConfig<HanaContainer, Builder> {
        private String mountsDirectory;
        private URL passwordsUrl;
        private String instanceNumber;
        private boolean agreeToSapLicense;

        private Builder(String version) {
            super("hana", 39017, 39017, version);
            this.image = "store/saplabs/hanaexpress:" + version;
            this.mountsDirectory = "/data/dockermounts";
            try {
                this.passwordsUrl = new URL("file:///hana/mounts/passwords.json");
            }
            catch (MalformedURLException e1) {
                log.log(System.Logger.Level.DEBUG, "Invalid passwords URL. Can't happen.");
            }
            this.instanceNumber = "90";
            this.agreeToSapLicense = HanaContainer.checkLicenseAgreement();
            this.adminUsername = "SYSTEM";
            this.adminPassword = "HXEHana1";
            this.password = "HXEHana1";
            this.dbName = "HXE";
            this.username = "test_user";
            this.maxReadyAttempts = 3000;
        }

        @Override
        protected void extraProperties(Properties properties) {
            super.extraProperties(properties);
            if (!Integer.toString(this.port).matches("\\d{5}")) {
                throw new IllegalArgumentException("Invalid port: " + this.port + ". The port must consist of exactly 5 digits.");
            }
            this.mountsDirectory = this.prop(properties, "mountsDirectory", "/data/dockermounts");
            if (!Files.isDirectory(Paths.get(this.mountsDirectory, new String[0]), new LinkOption[0])) {
                throw new IllegalArgumentException("The given mounts directory \"" + this.mountsDirectory + "\" doesn't exist or is not a directory");
            }
            try {
                this.passwordsUrl = new URL(this.prop(properties, "passwordsUrl", "file:///hana/mounts/passwords.json"));
            }
            catch (MalformedURLException e) {
                log.log(System.Logger.Level.WARNING, "Invalid passwords URL. Using default.", (Throwable)e);
                try {
                    this.passwordsUrl = new URL("file:///hana/mounts/passwords.json");
                }
                catch (MalformedURLException e1) {
                    log.log(System.Logger.Level.DEBUG, "Invalid passwords URL. Can't happen.");
                }
            }
            this.instanceNumber = this.prop(properties, "instanceNumber", "90");
            if (!this.instanceNumber.matches("\\d{2}")) {
                throw new IllegalArgumentException("Invalid instance number: " + this.instanceNumber + ". The instance number must consist of exactly two digits.");
            }
            if (!"90".equals(this.instanceNumber)) {
                String portStr = Integer.toString(this.port);
                this.port = Integer.parseInt(portStr.substring(0, 1) + this.instanceNumber + portStr.substring(3));
            }
            this.agreeToSapLicense = this.checkLicenseAgreementFor(properties);
        }

        @Override
        protected String buildJdbcUrl() {
            return "jdbc:sap://" + this.getHost() + ":" + this.getPort() + "/?databaseName=" + this.getDbName();
        }

        @Override
        public HanaContainer build() {
            return new HanaContainer(this);
        }

        @Override
        public HanaContainer start() {
            return this.build().start();
        }

        private String getMountsDirectory() {
            return this.mountsDirectory;
        }

        public Builder mountsDirectory(String mountsDirectory) {
            this.mountsDirectory = mountsDirectory;
            return (Builder)this.self();
        }

        private URL getPasswordsUrl() {
            return this.passwordsUrl;
        }

        public Builder passwordsUrl(URL passwordsUrl) {
            this.passwordsUrl = passwordsUrl;
            return (Builder)this.self();
        }

        private String getInstanceNumber() {
            return this.instanceNumber;
        }

        public Builder instanceNumber(String instanceNumber) {
            this.instanceNumber = instanceNumber;
            return (Builder)this.self();
        }

        private boolean isAgreeToSapLicense() {
            return this.agreeToSapLicense;
        }

        public Builder agreeToSapLicense(boolean agreeToSapLicense) {
            this.agreeToSapLicense = agreeToSapLicense;
            return (Builder)this.self();
        }

        private boolean checkLicenseAgreementFor(Properties properties) {
            String propertyValue = null;
            if (properties != null && (propertyValue = this.prop(properties, "agreeToSapLicense", null)) != null) {
                return Boolean.parseBoolean(propertyValue);
            }
            return HanaContainer.checkLicenseAgreement();
        }
    }
}

