/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.test.containers;

import io.ebean.test.containers.DbConfig;
import io.ebean.test.containers.MySqlBaseContainer;

public class MySqlContainer
extends MySqlBaseContainer {
    public MySqlContainer start() {
        this.startOrThrow();
        return this;
    }

    public static Builder builder(String version) {
        return new Builder(version);
    }

    @Deprecated
    public static Builder newBuilder(String version) {
        return MySqlContainer.builder(version);
    }

    private MySqlContainer(Builder builder) {
        super(builder);
    }

    public static class Builder
    extends DbConfig<MySqlContainer, Builder> {
        private Builder(String version) {
            super("mysql", 4306, 3306, version);
            this.adminUsername = "root";
            this.adminPassword = "admin";
            this.tmpfs = "/var/lib/mysql:rw";
        }

        protected Builder(String platform, int port, int internalPort, String version) {
            super(platform, port, internalPort, version);
        }

        @Override
        protected String buildJdbcUrl() {
            return "jdbc:mysql://" + this.getHost() + ":" + this.getPort() + "/" + this.getDbName();
        }

        @Override
        protected String buildJdbcAdminUrl() {
            return "jdbc:mysql://" + this.getHost() + ":" + this.getPort() + "/mysql";
        }

        @Override
        public MySqlContainer build() {
            return new MySqlContainer(this);
        }

        @Override
        public MySqlContainer start() {
            return this.build().start();
        }
    }
}

