/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.test.containers;

import io.ebean.test.containers.BaseBuilder;
import io.ebean.test.containers.ContainerBuilderDb;
import io.ebean.test.containers.ExtraAttributes;
import io.ebean.test.containers.ExtraBuilder;
import io.ebean.test.containers.InternalConfigDb;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.function.Consumer;

abstract class BaseDbBuilder<C, SELF extends BaseDbBuilder<C, SELF>>
extends BaseBuilder<C, SELF>
implements ContainerBuilderDb<C, SELF> {
    String tmpfs;
    String adminUsername = "admin";
    String adminPassword = "admin";
    final ExtraAttributes extra = new ExtraAttributes();
    final ExtraAttributes extra2 = new ExtraAttributes();
    String dbName = "test_db";
    String username;
    String password = "test";
    String schema;
    String extensions;
    private String initSqlFile;
    private String seedSqlFile;
    private boolean inMemory;
    boolean fastStartMode = true;
    protected String characterSet;
    protected String collation;

    BaseDbBuilder(String platform, int port, int internalPort, String version) {
        super(platform, port, internalPort, version);
    }

    protected String getDbName() {
        return this.dbName;
    }

    @Override
    public SELF properties(Properties properties) {
        if (properties == null) {
            return (SELF)((BaseDbBuilder)this.self());
        }
        super.properties(properties);
        this.characterSet = this.prop(properties, "characterSet", this.characterSet);
        this.collation = this.prop(properties, "collation", this.collation);
        this.inMemory = Boolean.parseBoolean(this.prop(properties, "inMemory", Boolean.toString(this.inMemory)));
        this.fastStartMode = Boolean.parseBoolean(this.prop(properties, "fastStartMode", Boolean.toString(this.fastStartMode)));
        this.tmpfs = this.prop(properties, "tmpfs", this.tmpfs);
        this.dbName = this.prop(properties, "dbName", this.dbName);
        this.username = this.prop(properties, "username", this.username);
        this.password = this.prop(properties, "password", this.password);
        this.schema = this.prop(properties, "schema", this.schema);
        this.extensions = this.prop(properties, "extensions", this.extensions);
        this.adminUsername = this.prop(properties, "adminUsername", this.adminUsername);
        this.adminPassword = this.prop(properties, "adminPassword", this.adminPassword);
        this.initSqlFile = this.prop(properties, "initSqlFile", this.initSqlFile);
        this.seedSqlFile = this.prop(properties, "seedSqlFile", this.seedSqlFile);
        this.extra.load(this.platform, "extraDb", properties);
        this.extra.load(this.platform, "extra", properties);
        this.extra2.load(this.platform, "extra2", properties);
        return (SELF)((BaseDbBuilder)this.self());
    }

    @Override
    public SELF adminUser(String dbAdminUser) {
        this.adminUsername = dbAdminUser;
        return (SELF)((BaseDbBuilder)this.self());
    }

    @Override
    public SELF adminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
        return (SELF)((BaseDbBuilder)this.self());
    }

    @Override
    public SELF tmpfs(String tmpfs) {
        this.tmpfs = tmpfs;
        return (SELF)((BaseDbBuilder)this.self());
    }

    @Override
    public SELF fastStartMode(boolean fastStartMode) {
        this.fastStartMode = fastStartMode;
        return (SELF)((BaseDbBuilder)this.self());
    }

    @Override
    public SELF dbName(String dbName) {
        this.dbName = dbName;
        return (SELF)((BaseDbBuilder)this.self());
    }

    @Override
    public SELF user(String user) {
        this.username = user;
        return (SELF)((BaseDbBuilder)this.self());
    }

    @Override
    public SELF password(String password) {
        this.password = password;
        return (SELF)((BaseDbBuilder)this.self());
    }

    @Override
    public SELF schema(String schema) {
        this.schema = schema;
        return (SELF)((BaseDbBuilder)this.self());
    }

    @Override
    public SELF characterSet(String characterSet) {
        this.characterSet = characterSet;
        return (SELF)((BaseDbBuilder)this.self());
    }

    @Override
    public SELF collation(String collation) {
        this.collation = collation;
        return (SELF)((BaseDbBuilder)this.self());
    }

    @Override
    public SELF extensions(String extensions) {
        this.extensions = extensions;
        return (SELF)((BaseDbBuilder)this.self());
    }

    @Override
    public SELF initSqlFile(String initSqlFile) {
        this.initSqlFile = initSqlFile;
        return (SELF)((BaseDbBuilder)this.self());
    }

    @Override
    public SELF seedSqlFile(String seedSqlFile) {
        this.seedSqlFile = seedSqlFile;
        return (SELF)((BaseDbBuilder)this.self());
    }

    @Override
    public SELF extraDb(String extraDb) {
        this.extra.dbName = extraDb;
        return (SELF)((BaseDbBuilder)this.self());
    }

    @Override
    public SELF extraDbUser(String extraDbUser) {
        this.extra.username = extraDbUser;
        return (SELF)((BaseDbBuilder)this.self());
    }

    @Override
    public SELF extraDbPassword(String extraDbPassword) {
        this.extra.password = extraDbPassword;
        return (SELF)((BaseDbBuilder)this.self());
    }

    @Override
    public SELF extraDbExtensions(String extraDbExtensions) {
        this.extra.extensions = extraDbExtensions;
        return (SELF)((BaseDbBuilder)this.self());
    }

    @Override
    public SELF extraDbInitSqlFile(String extraDbInitSqlFile) {
        this.extra.initSqlFile = extraDbInitSqlFile;
        return (SELF)((BaseDbBuilder)this.self());
    }

    @Override
    public SELF extraDbSeedSqlFile(String extraDbSeedSqlFile) {
        this.extra.seedSqlFile = extraDbSeedSqlFile;
        return (SELF)((BaseDbBuilder)this.self());
    }

    @Override
    public SELF extra(Consumer<ExtraBuilder> extraBuilder) {
        extraBuilder.accept(this.extra);
        return (SELF)((BaseDbBuilder)this.self());
    }

    @Override
    public SELF extra2(Consumer<ExtraBuilder> extraBuilder) {
        extraBuilder.accept(this.extra2);
        return (SELF)((BaseDbBuilder)this.self());
    }

    @Override
    public SELF inMemory(boolean inMemory) {
        this.inMemory = inMemory;
        return (SELF)((BaseDbBuilder)this.self());
    }

    protected void initDefaultSchema() {
        if (this.schema == null) {
            this.schema = this.deriveUsername();
        }
    }

    protected String buildSummary() {
        return "host:" + this.host + " port:" + this.port + " db:" + this.dbName + " user:" + this.deriveUsername() + "/" + this.password;
    }

    protected String deriveUsername() {
        return this.username == null ? this.dbName : this.username;
    }

    @Override
    protected InternalConfigDb internalConfig() {
        return new InnerConfig();
    }

    private class InnerConfig
    extends BaseBuilder.Inner
    implements InternalConfigDb {
        private InnerConfig() {
        }

        @Override
        public String startDescription() {
            return "starting " + BaseDbBuilder.this.platform + " container:" + BaseDbBuilder.this.containerName + " port:" + BaseDbBuilder.this.port + " db:" + BaseDbBuilder.this.dbName + " user:" + BaseDbBuilder.this.deriveUsername() + " extensions:" + BaseDbBuilder.this.extensions + " startMode:" + String.valueOf((Object)BaseDbBuilder.this.startMode);
        }

        @Override
        public String summary() {
            return BaseDbBuilder.this.buildSummary();
        }

        @Override
        public Connection createConnection() throws SQLException {
            Properties props = new Properties();
            props.put("user", this.getUsername());
            props.put("password", this.getPassword());
            if (BaseDbBuilder.this.schema != null) {
                props.put("schema", this.getSchema());
            }
            return DriverManager.getConnection(this.jdbcUrl(), props);
        }

        @Override
        public Connection createConnectionNoSchema() throws SQLException {
            Properties props = new Properties();
            props.put("user", this.getUsername());
            props.put("password", this.getPassword());
            return DriverManager.getConnection(this.jdbcUrl(), props);
        }

        @Override
        public Connection createAdminConnection(String url) throws SQLException {
            Properties props = new Properties();
            props.put("user", this.getAdminUsername());
            props.put("password", this.getAdminPassword());
            return DriverManager.getConnection(url, props);
        }

        @Override
        public Connection createAdminConnection() throws SQLException {
            return this.createAdminConnection(this.jdbcAdminUrl());
        }

        @Override
        public boolean isInMemory() {
            return BaseDbBuilder.this.inMemory;
        }

        @Override
        public String getTmpfs() {
            return BaseDbBuilder.this.tmpfs;
        }

        @Override
        public String getAdminUsername() {
            return BaseDbBuilder.this.adminUsername;
        }

        @Override
        public String getAdminPassword() {
            return BaseDbBuilder.this.adminPassword;
        }

        @Override
        public String getDbName() {
            return BaseDbBuilder.this.dbName;
        }

        @Override
        public String getUsername() {
            return BaseDbBuilder.this.deriveUsername();
        }

        @Override
        public String getPassword() {
            return BaseDbBuilder.this.password;
        }

        @Override
        public String getSchema() {
            return BaseDbBuilder.this.schema;
        }

        @Override
        public String getExtensions() {
            return BaseDbBuilder.this.extensions;
        }

        @Override
        public String getInitSqlFile() {
            return BaseDbBuilder.this.initSqlFile;
        }

        @Override
        public String getSeedSqlFile() {
            return BaseDbBuilder.this.seedSqlFile;
        }

        @Override
        public ExtraAttributes extra() {
            return BaseDbBuilder.this.extra;
        }

        @Override
        public ExtraAttributes extra2() {
            return BaseDbBuilder.this.extra2;
        }

        @Override
        public boolean isFastStartMode() {
            return BaseDbBuilder.this.fastStartMode;
        }

        @Override
        public String getCharacterSet() {
            return BaseDbBuilder.this.characterSet;
        }

        @Override
        public String getCollation() {
            return BaseDbBuilder.this.collation;
        }

        @Override
        public boolean isExplicitCollation() {
            return BaseDbBuilder.this.collation != null || BaseDbBuilder.this.characterSet != null;
        }

        @Override
        public boolean isDefaultCollation() {
            return "default".equals(BaseDbBuilder.this.collation);
        }
    }
}

