/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.test.containers;

import io.ebean.test.containers.BaseDbBuilder;
import io.ebean.test.containers.BaseJdbcContainer;
import io.ebean.test.containers.ExtraAttributes;
import io.ebean.test.containers.TrimSplit;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

abstract class BasePostgresContainer<C extends BasePostgresContainer<C>>
extends BaseJdbcContainer<C> {
    BasePostgresContainer(BaseDbBuilder<?, ?> config) {
        super(config);
    }

    @Override
    void createDatabase() {
        this.createRoleAndDatabase(false);
    }

    @Override
    void dropCreateDatabase() {
        this.createRoleAndDatabase(true);
    }

    private void createRoleAndDatabase(boolean withDrop) {
        try (Connection connection = this.config.createAdminConnection();){
            if (withDrop) {
                this.dropDatabaseIfExists(connection, this.dbConfig.getDbName());
                this.dropRoleIfExists(connection, this.dbConfig.getUsername());
            }
            if (this.databaseNotExists(connection, this.dbConfig.getDbName())) {
                this.createRole(connection);
                this.createDatabase(connection);
                this.createExtraDb(connection, withDrop, this.dbConfig.extra());
                this.createExtraDb(connection, withDrop, this.dbConfig.extra2());
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Error when creating database and role", e);
        }
    }

    private void dropRoleIfExists(Connection connection, String username) {
        if (this.defined(username)) {
            this.sqlRun(connection, "drop role if exists " + username);
        }
    }

    private void dropDatabaseIfExists(Connection connection, String dbName) {
        if (this.defined(dbName)) {
            this.sqlRun(connection, "drop database if exists " + dbName);
        }
    }

    private void createExtraDb(Connection connection, boolean withDrop, ExtraAttributes extra) {
        String extraDb = extra.dbName();
        if (!this.defined(extraDb)) {
            return;
        }
        String extraUser = extra.userWithDefaults(this.dbConfig.getUsername());
        if (this.defined(extraUser)) {
            if (withDrop) {
                this.dropDatabaseIfExists(connection, extraDb);
                this.dropRoleIfExists(connection, extraUser);
            }
            this.createRole(connection, extraUser, extra.passwordWithDefault(this.dbConfig.getPassword()));
            if (this.databaseNotExists(connection, extraDb)) {
                this.createExtraDatabase(connection, extraDb, extraUser, extra);
            }
        }
    }

    private void createDatabase(Connection connection) {
        this.createDatabaseWithOwner(connection, this.dbConfig.getDbName(), this.dbConfig.getUsername());
        this.addExtensions(this.dbConfig.getExtensions(), this.dbConfig.jdbcUrl());
        this.createDatabaseInitSql(this.dbConfig.getDbName(), this.dbConfig.getUsername(), this.dbConfig.getInitSqlFile(), this.dbConfig.getSeedSqlFile());
    }

    private void createExtraDatabase(Connection connection, String dbName, String username, ExtraAttributes attrs) {
        this.createDatabaseWithOwner(connection, dbName, username);
        this.addExtensions(attrs.extensions(), this.dbConfig.jdbcUrl(dbName));
        this.createDatabaseInitSql(dbName, username, attrs);
    }

    private void createRole(Connection connection) {
        this.createRole(connection, this.dbConfig.getUsername(), this.dbConfig.getPassword());
    }

    private void createRole(Connection connection, String username, String password) {
        if (this.defined(username) && !this.sqlHasRow(connection, "select rolname from pg_roles where rolname = '" + username + "'")) {
            this.sqlRun(connection, "create role " + username + " password '" + password + "' login createrole superuser");
        }
    }

    private boolean databaseNotExists(Connection connection, String dbName) {
        if (!this.defined(dbName)) {
            return false;
        }
        return !this.sqlHasRow(connection, "select 1 from pg_database where datname = '" + dbName + "'");
    }

    private void createDatabaseWithOwner(Connection connection, String dbName, String owner) {
        if (this.defined(dbName) && this.defined(owner)) {
            this.sqlRun(connection, "create database " + dbName + " with owner " + owner);
        }
    }

    private void createDatabaseInitSql(String extraDb, String extraUser, ExtraAttributes attrs) {
        this.createDatabaseInitSql(extraDb, extraUser, attrs.initSqlFile(), attrs.seedSqlFile());
    }

    private void createDatabaseInitSql(String dbName, String owner, String initSql, String seedSql) {
        if (this.defined(initSql)) {
            this.runDbSqlFile(dbName, owner, initSql);
        }
        if (this.defined(seedSql)) {
            this.runDbSqlFile(dbName, owner, seedSql);
        }
    }

    private void addExtensions(String dbExtensions, String jdbcUrl) {
        if (!this.defined(dbExtensions)) {
            return;
        }
        List<String> extensions = this.parseExtensions(dbExtensions);
        if (!extensions.isEmpty()) {
            try (Connection connection = this.dbConfig.createAdminConnection(jdbcUrl);){
                for (String extension : extensions) {
                    this.sqlRun(connection, "create extension if not exists \"" + extension + "\"");
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    protected void executeSqlFile(String dbUser, String dbName, String containerFilePath) {
        ProcessBuilder pb = this.sqlFileProcess(dbUser, dbName, containerFilePath);
        this.executeWithout("ERROR", pb, "Error executing init sql file: " + containerFilePath);
    }

    private ProcessBuilder sqlFileProcess(String dbUser, String dbName, String containerFilePath) {
        List<String> args = this.execPsql();
        args.add(dbUser);
        args.add("-d");
        args.add(dbName);
        args.add("-f");
        args.add(containerFilePath);
        return this.createProcessBuilder(args);
    }

    private List<String> parseExtensions(String dbExtn) {
        return TrimSplit.split(dbExtn);
    }

    private List<String> execPsql() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.config.docker());
        args.add("exec");
        args.add("-i");
        args.add(this.config.containerName());
        args.add("psql");
        args.add("-U");
        return args;
    }

    @Override
    protected ProcessBuilder runProcess() {
        List<String> args = this.dockerRun();
        if (this.dbConfig.isInMemory() && this.dbConfig.getTmpfs() != null) {
            args.add("--tmpfs");
            args.add(this.dbConfig.getTmpfs());
        }
        if (!this.dbConfig.getAdminPassword().isEmpty()) {
            args.add("-e");
            args.add("POSTGRES_PASSWORD=" + this.dbConfig.getAdminPassword());
        }
        args.add(this.config.getImage());
        return this.createProcessBuilder(args);
    }
}

