/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.test.containers;

import io.avaje.applog.AppLog;
import io.ebean.test.containers.CommandException;
import io.ebean.test.containers.process.ProcessHandler;
import io.ebean.test.containers.process.ProcessResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Commands {
    static final System.Logger log = AppLog.getLogger((String)"io.ebean.test.containers");
    private final String docker;

    public Commands() {
        this("docker");
    }

    public Commands(String docker) {
        this.docker = docker;
    }

    public void stopIfRunning(String containerName, boolean skipRunningCheck) {
        if (skipRunningCheck || this.isRunning(containerName)) {
            this.stop(containerName);
        }
    }

    public void removeIfRegistered(String containerName, boolean skipRunningCheck) {
        if (skipRunningCheck || this.isRegistered(containerName)) {
            this.remove(containerName);
        }
    }

    public void remove(String containerName) {
        log.log(System.Logger.Level.DEBUG, "remove {0}", containerName);
        ProcessHandler.command(this.docker, "rm", "-f", "--volumes", containerName);
    }

    public void start(String containerName) {
        log.log(System.Logger.Level.DEBUG, "start {0}", containerName);
        ProcessHandler.command(this.docker, "start", containerName);
    }

    public void stop(String containerName) {
        log.log(System.Logger.Level.DEBUG, "stop {0}", containerName);
        try {
            ProcessHandler.command(this.docker, "stop", containerName);
        }
        catch (CommandException e) {
            if (e.getMessage().contains("No such container")) {
                log.log(System.Logger.Level.TRACE, "container not running {0}", containerName);
            }
            log.log(System.Logger.Level.INFO, "Error stopping container - " + e.getMessage());
        }
    }

    public void removeContainers(String ... containerNames) {
        log.log(System.Logger.Level.DEBUG, "remove {0}", Arrays.toString(containerNames));
        try {
            ArrayList<String> args = new ArrayList<String>();
            args.add("-f");
            args.add("--volumes");
            args.addAll(Arrays.asList(containerNames));
            this.dockerCmd("rm", args);
        }
        catch (CommandException e) {
            log.log(System.Logger.Level.DEBUG, "removing containers that don't exist " + e.getMessage());
        }
    }

    public void stopContainers(String ... containerNames) {
        log.log(System.Logger.Level.DEBUG, "stop {0}", Arrays.toString(containerNames));
        try {
            this.dockerCmd("stop", Arrays.asList(containerNames));
        }
        catch (CommandException e) {
            log.log(System.Logger.Level.DEBUG, "stopping containers that don't exist " + e.getMessage());
        }
    }

    private void dockerCmd(String first, List<String> args) {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(this.docker);
        cmd.add(first);
        cmd.addAll(args);
        ProcessHandler.command(cmd);
    }

    public boolean isRunning(String containerName) {
        return this.running().contains(containerName);
    }

    public boolean isRegistered(String containerName) {
        return this.registered().contains(containerName);
    }

    public int port(String containerName) {
        List<String> lines = this.ports(containerName);
        for (String line : lines) {
            int port = Commands.parsePort(line);
            if (port <= 0) continue;
            return port;
        }
        return 0;
    }

    static int parsePort(String line) {
        String substring;
        int lastColon;
        int pos0 = line.indexOf("->");
        if (pos0 > -1 && (lastColon = (substring = line.substring(pos0 + 1)).lastIndexOf(58)) > -1) {
            return Integer.parseInt(substring.substring(lastColon + 1));
        }
        return 0;
    }

    public boolean logsContain(String containerName, String match) {
        return this.logsContain(containerName, match, null);
    }

    public boolean logsContain(String containerName, String match, String clearMatch) {
        List<String> matchLines = this.logsWithMatch(containerName, match, clearMatch);
        return !matchLines.isEmpty();
    }

    public List<String> logsWithMatch(String containerName, String match, String clearMatch) {
        ProcessResult result = ProcessHandler.matchCommand(match, clearMatch, this.docker, "logs", containerName);
        return result.getOutLines();
    }

    public List<String> logs(String containerName) {
        ProcessResult result = ProcessHandler.command(this.docker, "logs", containerName);
        return result.getOutLines();
    }

    private List<String> running() {
        ProcessResult result = ProcessHandler.command(this.docker, "ps", "--format", "{{.Names}}");
        return result.getOutLines();
    }

    private List<String> registered() {
        ProcessResult result = ProcessHandler.command(this.docker, "ps", "-a", "--format", "{{.Names}}");
        return result.getOutLines();
    }

    public List<String> ports(String containerName) {
        ProcessResult result = ProcessHandler.command(this.docker, "port", containerName);
        return result.getOutLines();
    }

    public String registeredPortMatch(String containerName, int matchPort) {
        ProcessResult result = ProcessHandler.command(this.docker, "container", "inspect", containerName, "--format={{.HostConfig.PortBindings}}");
        List<String> outLines = result.getOutLines();
        for (String outLine : outLines) {
            if (!outLine.startsWith("map")) continue;
            if (outLine.contains("{ " + matchPort + "}")) {
                return null;
            }
            return outLine;
        }
        return null;
    }

    public boolean logsContain(String containerName, String logMessage, int tail) {
        List<String> lines = this.logs(containerName, tail);
        for (String line : lines) {
            if (!line.contains(logMessage)) continue;
            return true;
        }
        return false;
    }

    public List<String> logs(String containerName, int tail) {
        ProcessResult result = tail > 0 ? ProcessHandler.command(this.docker, "logs", "--tail", Integer.toString(tail), containerName) : ProcessHandler.command(this.docker, "logs", containerName);
        return result.getOutLines();
    }
}

