/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.test.containers;

import io.ebean.test.containers.ClickHouseContainer;
import io.ebean.test.containers.CockroachContainer;
import io.ebean.test.containers.Container;
import io.ebean.test.containers.ContainerConfig;
import io.ebean.test.containers.Db2Container;
import io.ebean.test.containers.ElasticContainer;
import io.ebean.test.containers.HanaContainer;
import io.ebean.test.containers.MariaDBContainer;
import io.ebean.test.containers.MySqlContainer;
import io.ebean.test.containers.NuoDBContainer;
import io.ebean.test.containers.OracleContainer;
import io.ebean.test.containers.PostgisContainer;
import io.ebean.test.containers.PostgresContainer;
import io.ebean.test.containers.RedisContainer;
import io.ebean.test.containers.SqlServerContainer;
import io.ebean.test.containers.YugabyteContainer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;

public class ContainerFactory {
    private final Properties properties;
    private final List<Container> containers = new ArrayList<Container>();
    private final Set<String> runWith = new HashSet<String>();

    private static String defaultRunWith() {
        String runWith = System.getenv("DOCKER_RUN_WITH");
        return System.getProperty("docker_run_with", runWith);
    }

    public ContainerFactory(Properties properties) {
        this(properties, ContainerFactory.defaultRunWith());
    }

    public ContainerFactory(Properties properties, String runWith) {
        this.properties = properties;
        this.initRunWith(runWith);
        this.init();
    }

    private void initRunWith(String runWithOptions) {
        if (runWithOptions != null) {
            for (String value : runWithOptions.split(",")) {
                this.runWith.add(value.trim().toLowerCase());
            }
        }
    }

    private void init() {
        String db2Version;
        String yugaVersion;
        String cockroachVersion;
        String clickhouseVersion;
        String hanaVersion;
        String oracleVersion;
        String sqlServerVersion;
        String nuodbVersion;
        String mariadbVersion;
        String mysqlVersion;
        String pgisVersion;
        String pgVersion;
        String redisVersion;
        String elasticVersion = this.version("elastic");
        if (elasticVersion != null) {
            this.containers.add(((ElasticContainer.Builder)ElasticContainer.builder(elasticVersion).properties(this.properties)).build());
        }
        if ((redisVersion = this.version("redis")) != null) {
            this.containers.add(((RedisContainer.Builder)RedisContainer.builder(redisVersion).properties(this.properties)).build());
        }
        if ((pgVersion = this.runWithVersion("postgres")) != null) {
            this.containers.add(((PostgresContainer.Builder)PostgresContainer.builder(pgVersion).properties(this.properties)).build());
        }
        if ((pgisVersion = this.runWithVersion("postgis")) != null) {
            this.containers.add(((PostgisContainer.Builder)PostgisContainer.builder(pgisVersion).properties(this.properties)).build());
        }
        if ((mysqlVersion = this.runWithVersion("mysql")) != null) {
            this.containers.add(((MySqlContainer.Builder)MySqlContainer.builder(mysqlVersion).properties(this.properties)).build());
        }
        if ((mariadbVersion = this.runWithVersion("mariadb")) != null) {
            this.containers.add(((MariaDBContainer.Builder)MariaDBContainer.builder(mariadbVersion).properties(this.properties)).build());
        }
        if ((nuodbVersion = this.runWithVersion("nuodb")) != null) {
            this.containers.add(((NuoDBContainer.Builder)NuoDBContainer.builder(nuodbVersion).properties(this.properties)).build());
        }
        if ((sqlServerVersion = this.runWithVersion("sqlserver")) != null) {
            this.containers.add(((SqlServerContainer.Builder)SqlServerContainer.builder(sqlServerVersion).properties(this.properties)).build());
        }
        if ((oracleVersion = this.runWithVersion("oracle")) != null) {
            this.containers.add(((OracleContainer.Builder)OracleContainer.builder(oracleVersion).properties(this.properties)).build());
        }
        if ((hanaVersion = this.runWithVersion("hana")) != null) {
            this.containers.add(((HanaContainer.Builder)HanaContainer.builder(hanaVersion).properties(this.properties)).build());
        }
        if ((clickhouseVersion = this.runWithVersion("clickhouse")) != null) {
            this.containers.add(((ClickHouseContainer.Builder)ClickHouseContainer.builder(clickhouseVersion).properties(this.properties)).build());
        }
        if ((cockroachVersion = this.runWithVersion("cockroach")) != null) {
            this.containers.add(((CockroachContainer.Builder)CockroachContainer.builder(cockroachVersion).properties(this.properties)).build());
        }
        if ((yugaVersion = this.runWithVersion("yugabyte")) != null) {
            this.containers.add(((YugabyteContainer.Builder)YugabyteContainer.builder(yugaVersion).properties(this.properties)).build());
        }
        if ((db2Version = this.runWithVersion("db2")) != null) {
            this.containers.add(((Db2Container.Builder)Db2Container.builder(db2Version).properties(this.properties)).build());
        }
    }

    String runWithVersion(String name) {
        String version = this.version(name);
        if (version == null) {
            return null;
        }
        return this.runWith.isEmpty() || this.runWith.contains(name) ? version : null;
    }

    private String version(String prefix) {
        return this.properties.getProperty(prefix + ".version");
    }

    public void startContainers() {
        this.startContainers(null);
    }

    public void startContainers(Consumer<String> logging) {
        for (Container container : this.containers) {
            if (logging != null) {
                logging.accept(container.config().startDescription());
            }
            container.startMaybe();
        }
    }

    public void stopContainers() {
        this.stopContainers(null);
    }

    public void stopContainers(Consumer<String> logging) {
        for (Container container : this.containers) {
            if (logging != null) {
                logging.accept(container.config().stopDescription());
            }
            container.stop();
        }
    }

    public void stopOnly() {
        this.stopOnly(null);
    }

    public void stopOnly(Consumer<String> logging) {
        for (Container container : this.containers) {
            if (logging != null) {
                logging.accept(container.config().stopDescription());
            }
            container.stop();
        }
    }

    public ContainerConfig config(String platform) {
        Container container = this.container(platform);
        return container == null ? null : container.config();
    }

    public Container container(String platform) {
        for (Container container : this.containers) {
            ContainerConfig config = container.config();
            if (!config.platform().equalsIgnoreCase(platform)) continue;
            return container;
        }
        return null;
    }
}

