/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.test.containers;

import io.ebean.test.containers.BaseContainer;
import io.ebean.test.containers.BaseDbBuilder;
import io.ebean.test.containers.CommandException;
import io.ebean.test.containers.EbeanAdapter;
import io.ebean.test.containers.EbeanSDK;
import io.ebean.test.containers.InternalConfigDb;
import io.ebean.test.containers.process.ProcessHandler;
import java.io.File;
import java.net.URL;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;

abstract class DbContainer<C extends DbContainer<C>>
extends BaseContainer<C> {
    final InternalConfigDb dbConfig;
    boolean checkConnectivityUsingAdmin;
    int conditionPauseMillis = 100;

    DbContainer(BaseDbBuilder<?, ?> config) {
        super(config);
        this.dbConfig = config.internalConfig();
    }

    @Override
    void logRunning() {
        log.log(System.Logger.Level.INFO, "Container {0} running with {1} shutdownMode:{2}", this.logContainerName(), this.dbConfig.summary(), this.logContainerShutdown());
    }

    @Override
    void logRun() {
        log.log(System.Logger.Level.INFO, "Run container {0} with {1} shutdownMode:{2}", this.logContainerName(), this.dbConfig.summary(), this.logContainerShutdown());
    }

    @Override
    void logStart() {
        log.log(System.Logger.Level.INFO, "Start container {0} with {1} shutdownMode:{2}", this.logContainerName(), this.dbConfig.summary(), this.logContainerShutdown());
    }

    public String jdbcUrl() {
        return this.config.jdbcUrl();
    }

    public Connection createConnection() throws SQLException {
        return this.config.createConnection();
    }

    @Override
    public boolean startMaybe() {
        this.setDefaultContainerName();
        return this.shutdownHook(this.logStarted(this.startForMode()));
    }

    protected boolean startForMode() {
        switch (this.config.getStartMode()) {
            case DropCreate: {
                return this.startWithDropCreate();
            }
            case Container: {
                return this.startContainerOnly();
            }
        }
        return this.startWithCreate();
    }

    public boolean startWithCreate() {
        return this.startWithConnectivity();
    }

    public boolean startWithDropCreate() {
        return this.startWithConnectivity();
    }

    public boolean startContainerOnly() {
        this.startIfNeeded();
        if (!this.waitForDatabaseReady()) {
            log.log(System.Logger.Level.ERROR, "Failed waitForDatabaseReady for container {0}", this.config.containerName());
            return false;
        }
        if (!this.waitForConnectivity()) {
            log.log(System.Logger.Level.ERROR, "Failed waiting for connectivity for {0}", this.config.containerName());
            return false;
        }
        return true;
    }

    public EbeanSDK ebean() {
        return new EbeanAdapter(this.dbConfig);
    }

    protected boolean fastStart() {
        if (!this.dbConfig.isFastStartMode()) {
            return false;
        }
        try {
            return this.isFastStartDatabaseExists();
        }
        catch (CommandException e) {
            log.log(System.Logger.Level.DEBUG, "failed fast start check - using normal startup");
            return false;
        }
    }

    protected boolean isFastStartDatabaseExists() {
        return false;
    }

    @Override
    protected abstract ProcessBuilder runProcess();

    protected abstract boolean isDatabaseReady();

    protected abstract boolean isDatabaseAdminReady();

    protected void executeSqlFile(String dbUser, String dbName, String containerFilePath) {
        throw new RuntimeException("executeSqlFile is Not implemented for this platform - Postgres only at this stage");
    }

    public boolean waitForDatabaseReady() {
        return this.conditionLoop(this::isDatabaseReady) && this.conditionLoop(this::isDatabaseAdminReady);
    }

    private boolean conditionLoop(BooleanSupplier condition) {
        for (int i = 0; i < this.config.getMaxReadyAttempts(); ++i) {
            try {
                if (condition.getAsBoolean()) {
                    return true;
                }
                this.pause();
                continue;
            }
            catch (CommandException e) {
                this.pause();
            }
        }
        return false;
    }

    private void pause() {
        try {
            Thread.sleep(this.conditionPauseMillis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    boolean checkConnectivity() {
        return this.checkConnectivity(this.checkConnectivityUsingAdmin);
    }

    boolean checkConnectivity(boolean useAdmin) {
        try {
            log.log(System.Logger.Level.TRACE, "checkConnectivity on {0} ... ", this.config.containerName());
            try (Connection connection = useAdmin ? this.config.createAdminConnection() : this.config.createConnectionNoSchema();){
                log.log(System.Logger.Level.DEBUG, "connectivity confirmed for {0}", this.config.containerName());
            }
            return true;
        }
        catch (Throwable e) {
            if (e.getMessage().contains("No suitable driver found for")) {
                throw new RuntimeException("Error checking connectivity, missing JDBC Driver? " + e.getMessage(), e);
            }
            log.log(System.Logger.Level.TRACE, "connection failed: " + e.getMessage());
            return false;
        }
    }

    boolean defined(String val) {
        return val != null && !val.trim().isEmpty();
    }

    void runDbSqlFile(String dbName, String dbUser, String sqlFile) {
        File file;
        if (this.defined(sqlFile) && (file = this.getResourceOrFile(sqlFile)) != null) {
            this.runSqlFile(file, dbUser, dbName);
        }
    }

    void runSqlFile(File file, String dbUser, String dbName) {
        if (this.copyFileToContainer(file)) {
            String containerFilePath = "/tmp/" + file.getName();
            this.executeSqlFile(dbUser, dbName, containerFilePath);
        }
    }

    File getResourceOrFile(String sqlFile) {
        File file = new File(sqlFile);
        if (!file.exists()) {
            file = this.checkFileResource(sqlFile);
        }
        if (file == null) {
            log.log(System.Logger.Level.ERROR, "Could not find SQL file. No file exists at location or resource path for: " + sqlFile);
        }
        return file;
    }

    private File checkFileResource(String sqlFile) {
        try {
            File file;
            URL resource;
            if (!((String)sqlFile).startsWith("/")) {
                sqlFile = "/" + (String)sqlFile;
            }
            if ((resource = this.getClass().getResource((String)sqlFile)) != null && (file = Paths.get(resource.toURI()).toFile()).exists()) {
                return file;
            }
        }
        catch (Exception e) {
            log.log(System.Logger.Level.ERROR, "Failed to obtain File from resource for init SQL file: " + (String)sqlFile, (Throwable)e);
        }
        return null;
    }

    boolean copyFileToContainer(File sourceFile) {
        ProcessBuilder pb = this.copyFileToContainerProcess(sourceFile);
        return this.execute(pb, "Failed to copy file " + sourceFile.getAbsolutePath() + " to container");
    }

    private ProcessBuilder copyFileToContainerProcess(File sourceFile) {
        String dest = this.config.containerName() + ":/tmp/" + sourceFile.getName();
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.config.docker());
        args.add("cp");
        args.add(sourceFile.getAbsolutePath());
        args.add(dest);
        return this.createProcessBuilder(args);
    }

    boolean execute(String expectedLine, ProcessBuilder pb) {
        return this.execute(expectedLine, pb, null);
    }

    boolean execute(String expectedLine, ProcessBuilder pb, String errorMessage) {
        List<String> outLines = ProcessHandler.process(pb).getOutLines();
        if (!this.stdoutContains(outLines, expectedLine)) {
            if (errorMessage != null) {
                log.log(System.Logger.Level.ERROR, errorMessage + " stdOut:" + String.valueOf(outLines) + " Expected message:" + expectedLine);
            }
            return false;
        }
        return true;
    }

    boolean executeWithout(String errorMatch, ProcessBuilder pb, String errorMessage) {
        List<String> outLines = ProcessHandler.process(pb).getOutLines();
        if (this.stdoutContains(outLines, errorMatch)) {
            log.log(System.Logger.Level.ERROR, errorMessage + " stdOut:" + String.valueOf(outLines));
            return false;
        }
        return true;
    }

    boolean stdoutContains(List<String> outLines, String expectedLine) {
        for (String outLine : outLines) {
            if (!outLine.contains(expectedLine)) continue;
            return true;
        }
        return false;
    }

    boolean execute(ProcessBuilder pb, String errorMessage) {
        List<String> outLines = ProcessHandler.process(pb).getOutLines();
        if (!outLines.isEmpty()) {
            log.log(System.Logger.Level.ERROR, errorMessage + " stdOut:" + String.valueOf(outLines));
            return false;
        }
        return true;
    }

    void sqlProcess(Consumer<Connection> runner) {
        try (Connection connection = this.config.createAdminConnection();){
            runner.accept(connection);
        }
        catch (SQLException e) {
            throw new IllegalStateException("Failed to execute sql", e);
        }
    }

    void sqlRun(Connection connection, String sql) {
        log.log(System.Logger.Level.DEBUG, "sqlRun: {0}", sql);
        try (Statement statement = connection.createStatement();){
            statement.execute(sql);
        }
        catch (SQLException e) {
            throw new IllegalStateException("Failed to execute sql [" + sql + "]", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean sqlHasRow(Connection connection, String sql) {
        log.log(System.Logger.Level.TRACE, "sqlRun: {0}", sql);
        try (Statement statement = connection.createStatement();){
            try (ResultSet resultSet = statement.executeQuery(sql);){
                if (resultSet.next()) {
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            throw new IllegalStateException("Failed to execute sql", e);
        }
    }

    boolean sqlQueryMatch(Connection connection, String sql, String match) throws SQLException {
        log.log(System.Logger.Level.TRACE, "sqlRun: {0}", sql);
        try (PreparedStatement stmt = connection.prepareStatement(sql);
             ResultSet resultSet = stmt.executeQuery();){
            while (resultSet.next()) {
                if (!resultSet.getString(1).equalsIgnoreCase(match)) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }
}

