/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.test.containers;

import io.ebean.Database;
import io.ebean.DatabaseBuilder;
import io.ebean.datasource.DataSourceBuilder;
import io.ebean.test.containers.EbeanSDK;
import io.ebean.test.containers.ExtraAttributes;
import io.ebean.test.containers.InternalConfigDb;

final class EbeanAdapter
implements EbeanSDK {
    private final InternalConfigDb dbConfig;

    EbeanAdapter(InternalConfigDb dbConfig) {
        this.dbConfig = dbConfig;
    }

    @Override
    public DatabaseBuilder builder() {
        return Database.builder().dataSourceBuilder(this.dataSourceBuilder()).name(this.dbConfig.getDbName()).ddlGenerate(true).ddlRun(true);
    }

    @Override
    public DataSourceBuilder dataSourceBuilder() {
        return DataSourceBuilder.create().url(this.dbConfig.jdbcUrl()).username(this.dbConfig.getUsername()).password(this.dbConfig.getPassword());
    }

    private DataSourceBuilder dataSourceBuilder(ExtraAttributes extra) {
        String username = extra.userWithDefaults(this.dbConfig.getUsername());
        String password = extra.passwordWithDefault(this.dbConfig.getPassword());
        return DataSourceBuilder.create().url(this.dbConfig.jdbcUrl(extra.dbName())).username(username).password(password);
    }

    @Override
    public DataSourceBuilder extraDataSourceBuilder() {
        return this.dataSourceBuilder(this.dbConfig.extra());
    }

    @Override
    public DataSourceBuilder extra2DataSourceBuilder() {
        return this.dataSourceBuilder(this.dbConfig.extra2());
    }

    @Override
    public DatabaseBuilder extraDatabaseBuilder() {
        return EbeanAdapter.extraBuilder(this.extraDataSourceBuilder(), this.dbConfig.extra().dbName());
    }

    @Override
    public DatabaseBuilder extra2DatabaseBuilder() {
        return EbeanAdapter.extraBuilder(this.extra2DataSourceBuilder(), this.dbConfig.extra2().dbName());
    }

    private static DatabaseBuilder extraBuilder(DataSourceBuilder ds, String name) {
        return Database.builder().dataSourceBuilder(ds).name(name).defaultDatabase(false);
    }
}

