/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.test.containers;

import io.ebean.test.containers.ExtraBuilder;
import java.util.Properties;

final class ExtraAttributes
implements ExtraBuilder {
    String dbName;
    String extensions;
    String username;
    String password = "test";
    String initSqlFile;
    String seedSqlFile;

    ExtraAttributes() {
    }

    String dbName() {
        return this.dbName;
    }

    String userWithDefaults(String username) {
        String un = this.userWithDefault();
        return un != null && !un.equals(username) ? un : null;
    }

    private String userWithDefault() {
        return this.username != null ? this.username : this.dbName;
    }

    String passwordWithDefault(String password) {
        return this.password != null ? this.password : password;
    }

    String extensions() {
        return this.extensions;
    }

    String initSqlFile() {
        return this.initSqlFile;
    }

    String seedSqlFile() {
        return this.seedSqlFile;
    }

    void load(String platform, String prefix, Properties properties) {
        this.dbName = this.prop(platform, properties, prefix + ".dbName", this.prop(platform, properties, prefix, this.dbName));
        this.username = this.prop(platform, properties, prefix + ".username", this.username);
        this.password = this.prop(platform, properties, prefix + ".password", this.password);
        this.extensions = this.prop(platform, properties, prefix + ".extensions", this.extensions);
        this.initSqlFile = this.prop(platform, properties, prefix + ".initSqlFile", this.initSqlFile);
        this.seedSqlFile = this.prop(platform, properties, prefix + ".seedSqlFile", this.seedSqlFile);
    }

    private String prop(String platform, Properties properties, String key, String defaultValue) {
        String val = properties.getProperty("ebean.test." + platform + "." + key, defaultValue);
        return properties.getProperty(platform + "." + key, val);
    }

    @Override
    public ExtraBuilder dbName(String dbName) {
        this.dbName = dbName;
        return this;
    }

    @Override
    public ExtraBuilder extensions(String extensions) {
        this.extensions = extensions;
        return this;
    }

    @Override
    public ExtraBuilder username(String username) {
        this.username = username;
        return this;
    }

    @Override
    public ExtraBuilder password(String password) {
        this.password = password;
        return this;
    }

    @Override
    public ExtraBuilder initSqlFile(String initSqlFile) {
        this.initSqlFile = initSqlFile;
        return this;
    }

    @Override
    public ExtraBuilder seedSqlFile(String seedSqlFile) {
        this.seedSqlFile = seedSqlFile;
        return this;
    }
}

