/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.test.containers;

import io.ebean.test.containers.BaseContainer;
import io.ebean.test.containers.BaseDbBuilder;
import io.ebean.test.containers.BasePostgresContainer;

public class PostgisContainer
extends BasePostgresContainer<PostgisContainer> {
    @Override
    public PostgisContainer start() {
        this.startOrThrow();
        return this;
    }

    public static Builder builder(String version) {
        return new Builder(version);
    }

    @Deprecated
    public static Builder newBuilder(String version) {
        return PostgisContainer.builder(version);
    }

    private PostgisContainer(Builder config) {
        super(config);
    }

    public static class Builder
    extends BaseDbBuilder<PostgisContainer, Builder> {
        private boolean useLW;

        private Builder(String version) {
            super("postgis", 6432, 5432, version);
            this.image = "ghcr.io/baosystems/postgis:" + version;
            this.adminUsername = "postgres";
            this.tmpfs = "/var/lib/postgresql/data:rw";
            this.extra.extensions = this.extensions = "hstore,pgcrypto,postgis";
            this.extra2.extensions = this.extensions;
        }

        private String prefix() {
            return this.useLW ? "jdbc:postgresql_lwgis://" : "jdbc:postgresql://";
        }

        @Override
        protected String buildJdbcUrl() {
            return this.prefix() + this.host + ":" + this.port + "/" + this.dbName;
        }

        @Override
        protected String buildJdbcAdminUrl() {
            return this.prefix() + this.host + ":" + this.port + "/postgres";
        }

        @Override
        protected String buildExtraJdbcUrl(String dbName) {
            return this.prefix() + this.host + ":" + this.port + "/" + dbName;
        }

        public Builder useLW(boolean useLW) {
            this.useLW = useLW;
            if (useLW) {
                String driver = Builder.checkDriver();
                if (driver != null) {
                    BaseContainer.log.log(System.Logger.Level.DEBUG, "DriverWrapperLW exists {0}", driver);
                } else {
                    BaseContainer.log.log(System.Logger.Level.ERROR, "Missing dependency net.postgis:postgis-jdbc for DriverWrapperLW?");
                }
            }
            return this;
        }

        private static String checkDriver() {
            if (Builder.classExists("net.postgis.jdbc.DriverWrapperLW")) {
                return "net.postgis.jdbc.DriverWrapperLW";
            }
            if (Builder.classExists("org.postgis.DriverWrapperLW")) {
                return "org.postgis.DriverWrapperLW";
            }
            return null;
        }

        private static boolean classExists(String cn) {
            try {
                Class.forName(cn);
                return true;
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }

        @Override
        public PostgisContainer build() {
            return new PostgisContainer(this);
        }

        @Override
        public PostgisContainer start() {
            return this.build().start();
        }
    }
}

