/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.test.containers;

import io.ebean.test.containers.BaseDbBuilder;
import io.ebean.test.containers.BasePostgresContainer;

public class PostgresContainer
extends BasePostgresContainer<PostgresContainer> {
    @Override
    public PostgresContainer start() {
        this.startOrThrow();
        return this;
    }

    public static Builder builder(String version) {
        return new Builder(version);
    }

    @Deprecated
    public static Builder newBuilder(String version) {
        return PostgresContainer.builder(version);
    }

    private PostgresContainer(Builder config) {
        super(config);
    }

    public static class Builder
    extends BaseDbBuilder<PostgresContainer, Builder> {
        private Builder(String version) {
            super("postgres", 6432, 5432, version);
            this.adminUsername = "postgres";
            this.tmpfs = "/var/lib/postgresql/data:rw";
        }

        @Override
        protected String buildJdbcUrl() {
            return "jdbc:postgresql://" + this.host + ":" + this.port + "/" + this.dbName;
        }

        @Override
        protected String buildJdbcAdminUrl() {
            return "jdbc:postgresql://" + this.host + ":" + this.port + "/postgres";
        }

        @Override
        protected String buildExtraJdbcUrl(String dbName) {
            return "jdbc:postgresql://" + this.host + ":" + this.port + "/" + dbName;
        }

        @Override
        public PostgresContainer build() {
            return new PostgresContainer(this);
        }

        @Override
        public PostgresContainer start() {
            return this.build().start();
        }
    }
}

