/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.test.containers;

import io.ebean.test.containers.ContainerBuilder;
import io.ebean.test.containers.DockerHost;
import io.ebean.test.containers.InternalConfig;
import io.ebean.test.containers.SkipShutdown;
import io.ebean.test.containers.StartMode;
import io.ebean.test.containers.StopMode;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;

abstract class BaseBuilder<C, SELF extends BaseBuilder<C, SELF>>
implements ContainerBuilder<C, SELF> {
    protected final String platform;
    protected String containerName;
    protected String host = DockerHost.host();
    protected int port;
    protected int internalPort;
    protected int adminPort;
    protected int adminInternalPort;
    protected String mirror;
    protected String image;
    protected StartMode startMode = StartMode.Create;
    protected StopMode shutdownMode = StopMode.Auto;
    protected int maxReadyAttempts = 300;
    protected String docker = "docker";
    protected final String version;

    BaseBuilder(String platform, int port, int internalPort, String version) {
        this.platform = platform;
        this.port = port;
        this.internalPort = internalPort;
        this.image = platform + ":" + version;
        this.version = version;
    }

    protected String docker() {
        return this.docker;
    }

    protected String getHost() {
        return this.host;
    }

    protected int getPort() {
        return this.port;
    }

    protected SELF self() {
        return (SELF)this;
    }

    @Override
    public SELF startMode(StartMode startMode) {
        this.startMode = startMode;
        return this.self();
    }

    @Override
    public SELF shutdownMode(StopMode shutdownMode) {
        this.shutdownMode = shutdownMode;
        return this.self();
    }

    @Override
    public SELF properties(Properties properties) {
        if (properties == null) {
            return this.self();
        }
        this.docker = properties.getProperty("docker", this.docker);
        this.containerName = this.prop(properties, "containerName", this.containerName);
        this.image = this.prop(properties, "image", this.image);
        if (!SkipShutdown.isSkip()) {
            this.mirror = this.mirrorProperty(properties);
            if (this.mirror != null && !this.mirror.isBlank()) {
                this.image = BaseBuilder.imageWithMirror(this.mirror, this.image);
            }
        }
        this.host = this.prop(properties, "host", this.host);
        this.port = this.prop(properties, "port", this.port);
        this.internalPort = this.prop(properties, "internalPort", this.internalPort);
        this.adminPort = this.prop(properties, "adminPort", this.adminPort);
        this.adminInternalPort = this.prop(properties, "adminInternalPort", this.adminInternalPort);
        String start = properties.getProperty("startMode", this.startMode.name());
        this.startMode = StartMode.of(this.prop(properties, "startMode", start));
        String shutdown = properties.getProperty("shutdownMode", this.shutdownMode.name());
        this.shutdownMode = StopMode.of(this.prop(properties, "shutdownMode", shutdown));
        String maxVal = this.prop(properties, "maxReadyAttempts", null);
        if (maxVal != null) {
            try {
                this.maxReadyAttempts = Integer.parseInt(maxVal);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.extraProperties(properties);
        return this.self();
    }

    private String mirrorProperty(Properties properties) {
        String mirrorFromProps = properties.getProperty("ebean.test.containers.mirror", null);
        return System.getProperty("ebean.test.containers.mirror", mirrorFromProps);
    }

    static String imageWithMirror(String mirror, String image) {
        int beforeName = image.lastIndexOf(47);
        if (beforeName == -1) {
            return BaseBuilder.imageWithMirrorPrefix(mirror, "docker.io/", image);
        }
        int beforePath = image.lastIndexOf(47, beforeName - 1);
        if (beforePath == -1) {
            if (image.startsWith("localhost/")) {
                return image;
            }
            return BaseBuilder.imageWithMirrorPrefix(mirror, "docker.io/", image);
        }
        return BaseBuilder.imageWithMirrorPrefix(mirror, null, image);
    }

    private static String imageWithMirrorPrefix(String mirror, String dockerHub, String image) {
        String mirrorTrimmed = mirror.trim();
        StringBuilder sb = new StringBuilder(mirrorTrimmed);
        if (!mirrorTrimmed.endsWith("/")) {
            sb.append("/");
        }
        if (dockerHub != null) {
            sb.append(dockerHub);
        }
        return sb.append(image).toString();
    }

    protected void extraProperties(Properties properties) {
    }

    protected String prop(Properties properties, String key, String defaultValue) {
        String val = properties.getProperty("ebean.test." + this.platform + "." + key, defaultValue);
        return properties.getProperty(this.platform + "." + key, val);
    }

    protected int prop(Properties properties, String key, int defaultValue) {
        String val = properties.getProperty("ebean.test." + this.platform + "." + key);
        val = properties.getProperty(this.platform + "." + key, val);
        return val == null ? defaultValue : Integer.parseInt(val);
    }

    @Override
    public SELF containerName(String containerName) {
        this.containerName = containerName;
        return this.self();
    }

    @Override
    public SELF mirror(String mirror) {
        this.mirror = mirror;
        return this.self();
    }

    @Override
    public SELF port(int port) {
        this.port = port;
        return this.self();
    }

    @Override
    public SELF internalPort(int internalPort) {
        this.internalPort = internalPort;
        return this.self();
    }

    @Override
    public SELF adminPort(int adminPort) {
        this.adminPort = adminPort;
        return this.self();
    }

    @Override
    public SELF adminInternalPort(int adminInternalPort) {
        this.adminInternalPort = adminInternalPort;
        return this.self();
    }

    @Override
    public SELF image(String image) {
        this.image = image;
        return this.self();
    }

    @Override
    public SELF maxReadyAttempts(int maxReadyAttempts) {
        this.maxReadyAttempts = maxReadyAttempts;
        return this.self();
    }

    @Override
    public SELF docker(String docker) {
        this.docker = docker;
        return this.self();
    }

    protected InternalConfig internalConfig() {
        return new Inner();
    }

    protected String buildJdbcUrl() {
        throw new IllegalStateException("Not valid for this type");
    }

    protected String buildExtraJdbcUrl() {
        throw new IllegalStateException("Not valid for this type");
    }

    protected String buildJdbcAdminUrl() {
        return this.buildJdbcUrl();
    }

    protected class Inner
    implements InternalConfig {
        protected Inner() {
        }

        @Override
        public void setDefaultContainerName() {
            if (BaseBuilder.this.containerName == null && BaseBuilder.this.port != 0) {
                BaseBuilder.this.containerName = "ut_" + BaseBuilder.this.platform;
            }
        }

        @Override
        public void setContainerId(String containerId) {
            BaseBuilder.this.containerName = containerId;
        }

        @Override
        public void setAssignedPort(int assignedPort) {
            BaseBuilder.this.port = assignedPort;
        }

        @Override
        public Connection createConnection() throws SQLException {
            throw new IllegalStateException("Not valid for this type");
        }

        @Override
        public Connection createConnectionNoSchema() throws SQLException {
            throw new IllegalStateException("Not valid for this type");
        }

        @Override
        public Connection createAdminConnection() throws SQLException {
            throw new IllegalStateException("Not valid for this type");
        }

        @Override
        public Connection createAdminConnection(String url) throws SQLException {
            throw new IllegalStateException("Not valid for this type");
        }

        @Override
        public int port() {
            return this.getPort();
        }

        @Override
        public String jdbcUrl() {
            return BaseBuilder.this.buildJdbcUrl();
        }

        @Override
        public String jdbcExtraUrl() {
            return BaseBuilder.this.buildExtraJdbcUrl();
        }

        @Override
        public String jdbcAdminUrl() {
            return BaseBuilder.this.buildJdbcAdminUrl();
        }

        @Override
        public String startDescription() {
            return "starting " + BaseBuilder.this.platform + " container:" + BaseBuilder.this.containerName + " port:" + BaseBuilder.this.port + " startMode:" + String.valueOf((Object)BaseBuilder.this.startMode);
        }

        @Override
        public String stopDescription() {
            return "stopping " + BaseBuilder.this.platform + " container:" + BaseBuilder.this.containerName;
        }

        @Override
        public String platform() {
            return BaseBuilder.this.platform;
        }

        @Override
        public String containerName() {
            return BaseBuilder.this.containerName;
        }

        @Override
        public String version() {
            return BaseBuilder.this.version;
        }

        @Override
        public String getHost() {
            return BaseBuilder.this.host;
        }

        @Override
        public int getPort() {
            return BaseBuilder.this.port;
        }

        @Override
        public boolean randomPort() {
            return BaseBuilder.this.port == 0;
        }

        @Override
        public int getInternalPort() {
            return BaseBuilder.this.internalPort;
        }

        @Override
        public int getAdminPort() {
            return BaseBuilder.this.adminPort;
        }

        @Override
        public int getAdminInternalPort() {
            return BaseBuilder.this.adminInternalPort;
        }

        @Override
        public String getImage() {
            return BaseBuilder.this.image;
        }

        @Override
        public StartMode getStartMode() {
            return BaseBuilder.this.startMode;
        }

        @Override
        public int getMaxReadyAttempts() {
            return BaseBuilder.this.maxReadyAttempts;
        }

        @Override
        public String getDocker() {
            return BaseBuilder.this.docker;
        }

        @Override
        public StopMode shutdownMode() {
            return BaseBuilder.this.shutdownMode;
        }

        @Override
        public String docker() {
            return BaseBuilder.this.docker;
        }

        @Override
        public String image() {
            return BaseBuilder.this.image;
        }
    }
}

