/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.docker.commands;

import io.ebean.docker.commands.DbConfig;
import java.util.Properties;

public class Db2Config
extends DbConfig {
    private String createOptions;
    private String configOptions;

    public Db2Config(String version, Properties properties) {
        this(version);
        this.setProperties(properties);
    }

    public Db2Config(String version) {
        super("db2", 50000, 50000, version);
        this.image = "ibmcom/db2:" + version;
        this.setTmpfs("/database:rw");
    }

    protected Db2Config(String platform, int port, int internalPort, String version) {
        super(platform, port, internalPort, version);
    }

    @Override
    public String jdbcUrl() {
        return "jdbc:db2://localhost:" + this.getPort() + "/" + this.getDbName();
    }

    public String getCreateOptions() {
        return this.createOptions;
    }

    public void setCreateOptions(String createOptions) {
        this.createOptions = createOptions;
    }

    public String getConfigOptions() {
        return this.configOptions;
    }

    public void setConfigOptions(String configOptions) {
        this.configOptions = configOptions;
    }

    @Override
    public DbConfig setProperties(Properties properties) {
        if (properties == null) {
            return this;
        }
        super.setProperties(properties);
        this.createOptions = this.prop(properties, "createOptions", this.createOptions);
        this.configOptions = this.prop(properties, "configOptions", this.configOptions);
        return this;
    }
}

