/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.docker.commands;

import io.ebean.docker.commands.BaseConfig;
import io.ebean.docker.commands.Commands;
import io.ebean.docker.commands.InternalConfig;
import io.ebean.docker.commands.SkipShutdown;
import io.ebean.docker.commands.process.ProcessHandler;
import io.ebean.docker.container.Container;
import io.ebean.docker.container.ContainerConfig;
import io.ebean.docker.container.StopMode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseContainer
implements Container {
    static final Logger log = LoggerFactory.getLogger(Commands.class);
    protected final BaseConfig<?, ?> buildConfig;
    protected InternalConfig config;
    protected final Commands commands;
    protected int waitForConnectivityAttempts = 200;

    BaseContainer(BaseConfig<?, ?> buildConfig) {
        this.buildConfig = buildConfig;
        this.commands = new Commands(buildConfig.docker);
        this.config = buildConfig.internalConfig();
    }

    protected abstract ProcessBuilder runProcess();

    @Override
    public ContainerConfig config() {
        return this.config;
    }

    @Override
    public boolean start() {
        return this.shutdownHook(this.logStarted(this.startWithConnectivity()));
    }

    @Override
    public boolean isRunning() {
        return this.commands.isRunning(this.config.containerName());
    }

    public void registerShutdownHook() {
        if (!this.skipShutdown()) {
            Runtime.getRuntime().addShutdownHook(new Hook(this.config.shutdownMode()));
        }
    }

    private boolean skipShutdown() {
        return this.config.checkSkipShutdown() && SkipShutdown.isSkip();
    }

    protected boolean shutdownHook(boolean started) {
        if (StopMode.None != this.config.shutdownMode()) {
            this.registerShutdownHook();
        }
        return started;
    }

    protected boolean startWithConnectivity() {
        this.startIfNeeded();
        if (!this.waitForConnectivity()) {
            log.warn("Container {} failed to start - waiting for connectivity", (Object)this.config.containerName());
            return false;
        }
        return true;
    }

    boolean startIfNeeded() {
        if (this.commands.isRunning(this.config.containerName())) {
            this.checkPort(true);
            this.logRunning();
            return true;
        }
        if (this.commands.isRegistered(this.config.containerName())) {
            this.checkPort(false);
            this.logStart();
            this.startContainer();
        } else {
            this.logRun();
            this.runContainer();
        }
        return false;
    }

    void startContainer() {
        this.commands.start(this.config.containerName());
    }

    private void checkPort(boolean isRunning) {
        String portBindings = this.commands.registeredPortMatch(this.config.containerName(), this.config.getPort());
        if (portBindings != null) {
            String msg = "The existing port bindings [" + portBindings + "] for this docker container [" + this.config.containerName() + "] don't match the configured port [" + this.config.getPort() + "] so it seems the port has changed? Maybe look to remove the container first if you want to use the new port via:";
            if (isRunning) {
                msg = msg + "    docker stop " + this.config.containerName();
            }
            msg = msg + "    docker rm " + this.config.containerName();
            throw new IllegalStateException(msg);
        }
    }

    void runContainer() {
        ProcessHandler.process(this.runProcess());
    }

    boolean logsContain(String match, String clearMatch) {
        return this.logsContain(this.config.containerName(), match, clearMatch);
    }

    boolean logsContain(String containerName, String match, String clearMatch) {
        return this.commands.logsContain(containerName, match, clearMatch);
    }

    List<String> logs() {
        return this.commands.logs(this.config.containerName());
    }

    abstract boolean checkConnectivity();

    boolean waitForConnectivity() {
        log.debug("waitForConnectivity {} max attempts:{} ... ", (Object)this.config.containerName(), (Object)this.waitForConnectivityAttempts);
        for (int i = 0; i < this.waitForConnectivityAttempts; ++i) {
            if (this.checkConnectivity()) {
                return true;
            }
            try {
                int sleep = i < 10 ? 10 : (i < 20 ? 20 : 200);
                Thread.sleep(sleep);
                if (i <= 200 || i % 100 != 0) continue;
                log.info("waitForConnectivity {} attempts {} of {} ... ", new Object[]{this.config.containerName(), i, this.waitForConnectivityAttempts});
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
        return false;
    }

    @Override
    public void stop() {
        switch (this.config.getStopMode()) {
            case Remove: {
                this.stopRemove();
                break;
            }
            case Stop: {
                this.stopOnly();
            }
        }
    }

    public void stopRemove() {
        if (!this.config.isStopModeNone()) {
            this.commands.stopRemove(this.config.containerName());
        }
    }

    @Override
    public void stopOnly() {
        if (!this.config.isStopModeNone()) {
            this.commands.stopIfRunning(this.config.containerName());
        }
    }

    protected ProcessBuilder createProcessBuilder(List<String> args) {
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.command(args);
        if (log.isDebugEnabled()) {
            log.debug(String.join((CharSequence)" ", args));
        }
        return pb;
    }

    protected List<String> dockerRun() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.config.docker());
        args.add("run");
        args.add("-d");
        args.add("--name");
        args.add(this.config.containerName());
        args.add("-p");
        args.add(this.config.getPort() + ":" + this.config.getInternalPort());
        return args;
    }

    void logRunning() {
        log.info("Container {} already running with host:{} port:{}", new Object[]{this.config.containerName(), this.config.getHost(), this.config.getPort()});
    }

    void logRun() {
        log.info("Run container {} with host:{} port:{}", new Object[]{this.config.containerName(), this.config.getHost(), this.config.getPort()});
    }

    void logStart() {
        log.info("Start container {} with host:{} port:{}", new Object[]{this.config.containerName(), this.config.getHost(), this.config.getPort()});
    }

    void logNotStarted() {
        log.warn("Failed to start container {} with host:{} port:{}", new Object[]{this.config.containerName(), this.config.getHost(), this.config.getPort()});
    }

    void logStarted() {
        log.debug("Container {} ready with host:{} port:{}", new Object[]{this.config.containerName(), this.config.getHost(), this.config.getPort()});
    }

    boolean logStarted(boolean started) {
        if (!started) {
            this.logNotStarted();
        } else {
            this.logStarted();
        }
        return started;
    }

    protected String readUrlContent(String url) throws IOException {
        URLConnection yc = new URL(url).openConnection();
        StringBuilder sb = new StringBuilder(300);
        try (BufferedReader in = new BufferedReader(new InputStreamReader(yc.getInputStream(), StandardCharsets.UTF_8));){
            String inputLine;
            while ((inputLine = in.readLine()) != null) {
                sb.append(inputLine).append("\n");
            }
        }
        return sb.toString();
    }

    private class Hook
    extends Thread {
        private final StopMode mode;

        Hook(StopMode mode) {
            this.mode = mode;
        }

        @Override
        public void run() {
            if (StopMode.Remove == this.mode) {
                BaseContainer.this.stopRemove();
            } else {
                BaseContainer.this.stopOnly();
            }
        }
    }
}

