/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.docker.commands;

import io.ebean.docker.commands.DbConfig;
import io.ebean.docker.commands.JdbcBaseDbContainer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;

public class ClickHouseContainer
extends JdbcBaseDbContainer {
    public static Builder newBuilder(String version) {
        return new Builder(version);
    }

    ClickHouseContainer(Builder builder) {
        super(builder);
    }

    @Override
    void createDatabase() {
        this.createRoleAndDatabase(false);
    }

    @Override
    void dropCreateDatabase() {
        this.createRoleAndDatabase(true);
    }

    private void createRoleAndDatabase(boolean withDrop) {
        try (Connection connection = this.config.createAdminConnection();){
            if (withDrop) {
                this.dropDatabase(connection);
            }
            this.createDatabase(connection);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error when creating database and role", e);
        }
    }

    private void dropDatabase(Connection connection) {
        this.sqlRun(connection, "drop database if exists " + this.dbConfig.getDbName());
    }

    private void createDatabase(Connection connection) {
        this.sqlRun(connection, "create database if not exists " + this.dbConfig.getDbName());
    }

    @Override
    protected ProcessBuilder runProcess() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.config.docker());
        args.add("run");
        args.add("-d");
        args.add("--name");
        args.add(this.config.containerName());
        args.add("--ulimit");
        args.add("nofile=262144:262144");
        args.add("-p");
        args.add(this.config.getPort() + ":" + this.config.getInternalPort());
        args.add(this.config.getImage());
        ProcessBuilder pb = this.createProcessBuilder(args);
        pb.redirectErrorStream(true);
        return pb;
    }

    public static class Builder
    extends DbConfig<ClickHouseContainer, Builder> {
        private Builder(String version) {
            super("clickhouse", 8123, 8123, version);
            this.image = "yandex/clickhouse-server:" + version;
            this.username = "default";
            this.password = "";
            this.adminUsername = "default";
            this.adminPassword = "";
        }

        @Override
        protected String buildJdbcUrl() {
            return "jdbc:clickhouse://" + this.getHost() + ":" + this.getPort() + "/" + this.getDbName();
        }

        @Override
        protected String buildJdbcAdminUrl() {
            return "jdbc:clickhouse://" + this.getHost() + ":" + this.getPort() + "/default";
        }

        @Override
        public Builder user(String user) {
            return (Builder)super.user(user);
        }

        @Override
        public ClickHouseContainer build() {
            return new ClickHouseContainer(this);
        }
    }
}

