/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.docker.commands;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClientBuilder;
import io.ebean.docker.commands.BaseConfig;
import io.ebean.docker.commands.BaseContainer;
import io.ebean.docker.container.StopMode;
import java.util.List;
import java.util.Properties;

public class LocalDynamoDBContainer
extends BaseContainer {
    private final Builder localConfig;
    private final String endpointUrl;

    public static Builder newBuilder(String version) {
        return new Builder(version);
    }

    public LocalDynamoDBContainer(Builder builder) {
        super(builder);
        this.localConfig = builder;
        this.endpointUrl = String.format("http://%s:%s", this.config.getHost(), this.config.getPort());
    }

    public AmazonDynamoDB dynamoDB() {
        return (AmazonDynamoDB)((AmazonDynamoDBClientBuilder)((AmazonDynamoDBClientBuilder)AmazonDynamoDBClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials("localstack", "localstack")))).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.endpointUrl, this.localConfig.awsRegion()))).build();
    }

    @Override
    public boolean checkConnectivity() {
        return true;
    }

    @Override
    protected ProcessBuilder runProcess() {
        List<String> args = this.dockerRun();
        if (this.notEmpty(this.localConfig.awsRegion())) {
            args.add("-e");
            args.add("DEFAULT_REGION=" + this.localConfig.awsRegion());
        }
        args.add("-e");
        args.add("AWS_ACCESS_KEY_ID=localstack");
        args.add("-e");
        args.add("AWS_SECRET_KEY=localstack");
        args.add(this.config.image());
        return this.createProcessBuilder(args);
    }

    private boolean notEmpty(String value) {
        return value != null && !value.isEmpty();
    }

    public static class Builder
    extends BaseConfig<LocalDynamoDBContainer, Builder> {
        private String awsRegion = "ap-southeast-2";

        private Builder(String version) {
            super("dynamodb", 8001, 8000, version);
            this.image = "amazon/dynamodb-local:" + version;
            this.checkSkipShutdown = true;
            this.shutdownMode = StopMode.Remove;
        }

        @Override
        protected void extraProperties(Properties properties) {
            this.awsRegion = this.prop(properties, "awsRegion", this.awsRegion);
        }

        public Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        private String awsRegion() {
            return this.awsRegion;
        }

        @Override
        public LocalDynamoDBContainer build() {
            return new LocalDynamoDBContainer(this);
        }
    }
}

