/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.docker.commands;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClientBuilder;
import com.amazonaws.services.kinesis.AmazonKinesis;
import com.amazonaws.services.kinesis.AmazonKinesisClientBuilder;
import com.amazonaws.services.sns.AmazonSNS;
import com.amazonaws.services.sns.AmazonSNSClientBuilder;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSClientBuilder;
import io.ebean.docker.commands.BaseConfig;
import io.ebean.docker.commands.BaseContainer;
import io.ebean.docker.commands.TrimSplit;
import io.ebean.docker.container.StopMode;
import java.io.IOException;
import java.util.List;
import java.util.Properties;

public class LocalstackContainer
extends BaseContainer {
    private final Builder localConfig;
    private final List<String> serviceNames;
    private final String healthUrl;
    private final String endpointUrl;

    public static Builder newBuilder(String version) {
        return new Builder(version);
    }

    public LocalstackContainer(Builder builder) {
        super(builder);
        this.localConfig = builder;
        this.serviceNames = TrimSplit.split(this.localConfig.services());
        this.healthUrl = String.format("http://%s:%s/health", this.config.getHost(), this.config.getPort());
        this.endpointUrl = String.format("http://%s:%s/", this.config.getHost(), this.config.getPort());
    }

    public static LocalstackContainer create(String version, Properties properties) {
        return ((Builder)LocalstackContainer.newBuilder(version).properties(properties)).build();
    }

    public AmazonDynamoDB dynamoDB() {
        return (AmazonDynamoDB)((AmazonDynamoDBClientBuilder)((AmazonDynamoDBClientBuilder)AmazonDynamoDBClientBuilder.standard().withCredentials((AWSCredentialsProvider)this.credentials())).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.endpointUrl, this.localConfig.awsRegion()))).build();
    }

    public AmazonKinesis kinesis() {
        return (AmazonKinesis)((AmazonKinesisClientBuilder)((AmazonKinesisClientBuilder)AmazonKinesisClientBuilder.standard().withCredentials((AWSCredentialsProvider)this.credentials())).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.endpointUrl, this.localConfig.awsRegion()))).build();
    }

    public AmazonSNS sns() {
        return (AmazonSNS)((AmazonSNSClientBuilder)((AmazonSNSClientBuilder)AmazonSNSClientBuilder.standard().withCredentials((AWSCredentialsProvider)this.credentials())).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.endpointUrl, this.localConfig.awsRegion()))).build();
    }

    public AmazonSQS sqs() {
        return (AmazonSQS)((AmazonSQSClientBuilder)((AmazonSQSClientBuilder)AmazonSQSClientBuilder.standard().withCredentials((AWSCredentialsProvider)this.credentials())).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.endpointUrl, this.localConfig.awsRegion()))).build();
    }

    public AWSStaticCredentialsProvider credentials() {
        return new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials("localstack", "localstack"));
    }

    public String endpointUrl() {
        return this.endpointUrl;
    }

    public String awsRegion() {
        return this.localConfig.awsRegion();
    }

    @Override
    boolean checkConnectivity() {
        try {
            String content = this.readUrlContent(this.healthUrl);
            if (log.isTraceEnabled()) {
                log.trace("checkConnectivity content: {}", (Object)content);
            }
            return this.checkStatus(content);
        }
        catch (IOException e) {
            return false;
        }
    }

    private boolean checkStatus(String content) {
        String[] serviceEntries = content.split(",");
        for (String serviceName : this.serviceNames) {
            if (this.isServiceReady(serviceName, serviceEntries)) continue;
            return false;
        }
        return true;
    }

    private boolean isServiceReady(String serviceName, String[] serviceEntries) {
        String key = "\"" + serviceName + "\":";
        for (String serviceEntry : serviceEntries) {
            if ((!serviceEntry.contains(key) || !serviceEntry.contains("\"running\"")) && !serviceEntry.contains("\"available\"")) continue;
            return true;
        }
        return false;
    }

    @Override
    protected ProcessBuilder runProcess() {
        List<String> args = this.dockerRun();
        args.add("-p");
        args.add(this.config.getAdminPort() + ":" + this.config.getAdminInternalPort());
        if (this.notEmpty(this.localConfig.services())) {
            args.add("-e");
            args.add("LOCALSTACK_SERVICES=" + this.localConfig.services());
        }
        if (this.notEmpty(this.localConfig.awsRegion())) {
            args.add("-e");
            args.add("DEFAULT_REGION=" + this.localConfig.awsRegion());
        }
        if (this.notEmpty(this.localConfig.startWeb())) {
            args.add("-e");
            args.add("START_WEB=" + this.localConfig.startWeb());
        }
        args.add(this.config.image());
        return this.createProcessBuilder(args);
    }

    private boolean notEmpty(String value) {
        return value != null && !value.isEmpty();
    }

    public static class Builder
    extends BaseConfig<LocalstackContainer, Builder> {
        private String services = "dynamodb";
        private String awsRegion = "ap-southeast-2";
        private String startWeb = "0";

        private Builder(String version) {
            super("localstack", 4566, 4566, version);
            this.adminPort(4571);
            this.adminInternalPort(4571);
            this.checkSkipShutdown = true;
            this.shutdownMode = StopMode.Remove;
            this.image = "localstack/localstack:" + version;
        }

        @Override
        protected void extraProperties(Properties properties) {
            super.extraProperties(properties);
            this.services = this.prop(properties, "services", this.services);
            this.awsRegion = this.prop(properties, "awsRegion", this.awsRegion);
            this.startWeb = this.prop(properties, "startWeb", this.startWeb);
        }

        public Builder services(String services) {
            this.services = services;
            return (Builder)this.self();
        }

        public Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return (Builder)this.self();
        }

        public Builder startWeb(String startWeb) {
            this.startWeb = startWeb;
            return (Builder)this.self();
        }

        private String services() {
            return this.services;
        }

        private String awsRegion() {
            return this.awsRegion;
        }

        private String startWeb() {
            return this.startWeb;
        }

        @Override
        public LocalstackContainer build() {
            return new LocalstackContainer(this);
        }
    }
}

