/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.docker.commands;

import io.ebean.docker.commands.CommandException;
import io.ebean.docker.commands.DbConfig;
import io.ebean.docker.commands.JdbcBaseDbContainer;
import io.ebean.docker.commands.process.ProcessHandler;
import io.ebean.docker.commands.process.ProcessResult;
import java.io.File;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class NuoDBContainer
extends JdbcBaseDbContainer {
    private static final String AD_RESET = "com.nuodb.nagent.AgentMain main Entering initializing for server";
    private static final String AD_RUNNING = "com.nuodb.nagent.AgentMain main NuoAdmin Server running";
    private static final String SM_RESET = "Starting Storage Manager";
    private static final String SM_RUNNING = "Database formed";
    private static final String SM_UNABLE_TO_CONNECT = "Unable to connect ";
    private static final String TE_RESET = "Starting Transaction Engine";
    private static final String TE_RUNNING = "Database entered";
    private final Builder nuoConfig;
    private final String network;
    private final String adName;
    private final String smName;
    private final String teName;

    public static Builder newBuilder(String version) {
        return new Builder(version);
    }

    private NuoDBContainer(Builder builder) {
        super(builder);
        this.nuoConfig = builder;
        this.checkConnectivityUsingAdmin = true;
        this.nuoConfig.initDefaultSchema();
        this.network = this.nuoConfig.getNetwork();
        this.adName = this.config.containerName();
        this.smName = this.adName + "_" + this.nuoConfig.getSm1();
        this.teName = this.adName + "_" + this.nuoConfig.getTe1();
    }

    @Override
    public void stopRemove() {
        if (this.stopDatabase()) {
            this.commands.removeContainers(this.teName, this.smName, this.adName);
        }
        if (this.networkExists()) {
            this.removeNetwork();
        }
    }

    private void removeNetwork() {
        ProcessHandler.process(this.procNetworkRemove());
    }

    @Override
    public void stopOnly() {
        this.stopDatabase();
    }

    private boolean stopDatabase() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.config.docker());
        args.add("exec");
        args.add("-i");
        args.add(this.adName);
        args.add("nuocmd");
        args.add("shutdown");
        args.add("database");
        args.add("--db-name");
        args.add(this.dbConfig.getDbName());
        ProcessResult result = ProcessHandler.process(this.createProcessBuilder(args));
        if (!result.success()) {
            log.error("Error performing shutdown database " + result);
            return false;
        }
        this.waitTime(100L);
        this.commands.stop(this.adName);
        return true;
    }

    @Override
    void runContainer() {
        this.createNetwork();
        ProcessHandler.process(this.runAdminProcess());
        if (this.waitForAdminProcess()) {
            ProcessHandler.process(this.runStorageManager());
            if (this.waitForStorageManager()) {
                ProcessHandler.process(this.runTransactionManager());
                this.waitForTransactionManager();
            }
        }
    }

    private boolean waitForTransactionManager() {
        return this.waitForLogs(this.teName, TE_RUNNING, TE_RESET) && this.waitTime(100L);
    }

    private boolean storageManagerUnableToConnect() {
        boolean unableToConnect = false;
        List<String> logs = this.commands.logs(this.smName);
        for (String log : logs) {
            if (log.contains(SM_UNABLE_TO_CONNECT)) {
                unableToConnect = true;
                continue;
            }
            if (!log.contains(SM_RUNNING)) continue;
            unableToConnect = false;
        }
        return unableToConnect;
    }

    private boolean waitForStorageManager() {
        return this.waitForLogs(this.smName, SM_RUNNING, SM_RESET);
    }

    private boolean waitForAdminProcess() {
        return this.waitForLogs(this.config.containerName(), AD_RUNNING, AD_RESET);
    }

    private boolean waitTime(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            e.printStackTrace();
        }
        return true;
    }

    private boolean waitForLogs(String containerName, String match, String resetMatch) {
        for (int i = 0; i < 150; ++i) {
            if (this.logsContain(containerName, match, resetMatch)) {
                return true;
            }
            try {
                int sleep = i < 10 ? 10 : (i < 20 ? 20 : 100);
                Thread.sleep(sleep);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
        return false;
    }

    @Override
    void startContainer() {
        if (!this.isArchivePopulated()) {
            this.removeContainersAndRun();
        } else {
            this.commands.start(this.adName);
            if (!this.waitForAdminProcess() || !this.waitForDatabaseState()) {
                throw new RuntimeException("Failed waiting for NuoDB admin container [" + this.smName + "] to start running");
            }
            if (!this.startStorageManager(0)) {
                throw new RuntimeException("Failed to start storage manager NuoDB [" + this.adName + "]");
            }
            this.commands.start(this.teName);
            if (!this.waitForTransactionManager()) {
                throw new RuntimeException("Failed waiting for NuoDB transaction manager [" + this.smName + "] to start running");
            }
        }
    }

    private void removeContainersAndRun() {
        log.info("Archive directory is empty, remove containers and run");
        this.commands.removeContainers(this.teName, this.smName, this.adName);
        this.runContainer();
    }

    private boolean waitForDatabaseState() {
        this.waitTime(100L);
        for (int i = 0; i < 20; ++i) {
            if (this.checkDbStateOk()) {
                return true;
            }
            this.waitTime(100L);
        }
        return false;
    }

    private boolean checkDbStateOk() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.config.docker());
        args.add("exec");
        args.add("-i");
        args.add(this.adName);
        args.add("nuocmd");
        args.add("show");
        args.add("database");
        args.add("--db-format");
        args.add("dbState:{state}");
        args.add("--db-name");
        args.add(this.dbConfig.getDbName());
        try {
            ProcessResult result = ProcessHandler.process(this.createProcessBuilder(args));
            if (result.success()) {
                for (String outLine : result.getOutLines()) {
                    String trimmedOut = outLine.trim();
                    if (!trimmedOut.startsWith("dbState:")) continue;
                    return this.dbStateOk(trimmedOut);
                }
            }
        }
        catch (CommandException e) {
            return false;
        }
        return false;
    }

    private boolean dbStateOk(String trimmedOut) {
        log.trace("checking dbStateOk [{}]", (Object)trimmedOut);
        return trimmedOut.contains("NOT_RUNNING") || trimmedOut.contains("RUNNING");
    }

    private boolean startStorageManager(int attempt) {
        this.commands.start(this.smName);
        if (!this.waitForStorageManager()) {
            log.error("Failed waiting for NuoDB storage manager [" + this.adName + "] to start running");
            return false;
        }
        if (this.storageManagerUnableToConnect()) {
            log.info("Retry NuoDB storage manager [" + this.adName + "] attempt:" + attempt);
            return attempt <= 2 && this.startStorageManager(attempt + 1);
        }
        return true;
    }

    private void createNetwork() {
        if (!this.networkExists()) {
            ProcessHandler.process(this.procNetworkCreate());
        }
    }

    private boolean networkExists() {
        return this.execute(this.network, this.procNetworkList());
    }

    private ProcessBuilder procNetworkCreate() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.config.docker());
        args.add("network");
        args.add("create");
        args.add(this.network);
        return this.createProcessBuilder(args);
    }

    private ProcessBuilder procNetworkRemove() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.config.docker());
        args.add("network");
        args.add("rm");
        args.add(this.network);
        return this.createProcessBuilder(args);
    }

    private ProcessBuilder procNetworkList() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.config.docker());
        args.add("network");
        args.add("ls");
        args.add("-f");
        args.add("name=" + this.network);
        return this.createProcessBuilder(args);
    }

    @Override
    protected ProcessBuilder runProcess() {
        throw new RuntimeException("Not used for NuoDB container");
    }

    private ProcessBuilder runAdminProcess() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.config.docker());
        args.add("run");
        args.add("-d");
        args.add("--name");
        args.add(this.adName);
        args.add("--hostname");
        args.add(this.adName);
        args.add("--net");
        args.add(this.network);
        args.add("-p");
        args.add(this.config.getPort() + ":" + this.config.getInternalPort());
        args.add("-p");
        args.add(this.nuoConfig.getPort2() + ":" + this.nuoConfig.getInternalPort2());
        args.add("-p");
        args.add(this.nuoConfig.getPort3() + ":" + this.nuoConfig.getInternalPort3());
        if (this.defined(this.dbConfig.getAdminPassword())) {
            args.add("-e");
            args.add("NUODB_DOMAIN_ENTRYPOINT=" + this.adName);
        }
        args.add(this.config.getImage());
        args.add("nuoadmin");
        return this.createProcessBuilder(args);
    }

    private ProcessBuilder runStorageManager() {
        Path archiveDir = this.archivePath();
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.config.docker());
        args.add("run");
        args.add("-d");
        args.add("--name");
        args.add(this.smName);
        args.add("--hostname");
        args.add(this.smName);
        args.add("--volume");
        args.add(archiveDir.toAbsolutePath().toString() + ":/var/opt/nuodb/archive");
        args.add("--net");
        args.add(this.network);
        args.add(this.config.getImage());
        args.add("nuodocker");
        args.add("--api-server");
        args.add(this.adName + ":" + this.config.getPort());
        args.add("start");
        args.add("sm");
        args.add("--db-name");
        args.add(this.dbConfig.getDbName());
        args.add("--server-id");
        args.add(this.adName);
        args.add("--dba-user");
        args.add(this.dbConfig.getAdminUsername());
        args.add("--dba-password");
        args.add(this.dbConfig.getAdminPassword());
        args.add("--labels");
        args.add(this.nuoConfig.getLabels());
        args.add("--archive-dir");
        args.add("/var/opt/nuodb/archive");
        return this.createProcessBuilder(args);
    }

    boolean deleteDirectory(File dir) {
        File[] allContents = dir.listFiles();
        if (allContents != null) {
            for (File file : allContents) {
                this.deleteDirectory(file);
            }
        }
        return dir.delete();
    }

    private Path archivePath() {
        File nuoArchive = this.archiveFile();
        if (nuoArchive.exists()) {
            log.info("delete " + nuoArchive.toPath());
            this.deleteDirectory(nuoArchive);
        } else {
            nuoArchive.setWritable(true, false);
            if (!nuoArchive.mkdirs()) {
                throw new RuntimeException("Failed to re-create " + nuoArchive.getAbsolutePath());
            }
        }
        return nuoArchive.toPath();
    }

    private boolean isArchivePopulated() {
        File file = this.archiveFile();
        if (file.exists()) {
            File[] files = file.listFiles();
            return files != null && files.length > 0;
        }
        return false;
    }

    private File archiveFile() {
        File tmp = new File(System.getProperty("java.io.tmpdir"));
        return new File(new File(tmp, "nuodb"), this.dbConfig.getDbName());
    }

    private ProcessBuilder runTransactionManager() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.config.docker());
        args.add("run");
        args.add("-d");
        args.add("--name");
        args.add(this.teName);
        args.add("--hostname");
        args.add(this.teName);
        args.add("--net");
        args.add(this.network);
        args.add(this.config.getImage());
        args.add("nuodocker");
        args.add("--api-server");
        args.add(this.adName + ":" + this.config.getPort());
        args.add("start");
        args.add("te");
        args.add("--db-name");
        args.add(this.dbConfig.getDbName());
        args.add("--server-id");
        args.add(this.adName);
        return this.createProcessBuilder(args);
    }

    @Override
    public boolean isDatabaseReady() {
        return this.commands.logsContain(this.config.containerName(), "NuoAdmin Server running");
    }

    @Override
    protected boolean isDatabaseAdminReady() {
        return true;
    }

    @Override
    void createDatabase() {
        this.createSchemaAndUser(false);
    }

    @Override
    void dropCreateDatabase() {
        this.createSchemaAndUser(true);
    }

    private void createSchemaAndUser(boolean withDrop) {
        try (Connection connection = this.config.createAdminConnection();){
            boolean userExists;
            boolean schemaExists;
            if (withDrop) {
                this.sqlDropSchema(connection, this.dbConfig.getSchema());
            }
            if (!(schemaExists = this.sqlSchemaExists(connection, this.dbConfig.getSchema()))) {
                this.sqlCreateSchema(connection, this.dbConfig.getSchema());
            }
            if (!(userExists = this.sqlUserExists(connection, this.dbConfig.getUsername()))) {
                this.sqlCreateUser(connection, this.dbConfig.getUsername(), this.dbConfig.getPassword());
            }
            if (withDrop || !userExists) {
                this.sqlUserGrants(connection, this.dbConfig.getSchema(), this.dbConfig.getUsername());
            }
            connection.commit();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void sqlDropSchema(Connection connection, String schema) throws SQLException {
        this.exeSql(connection, "drop schema " + schema + " cascade if exists");
    }

    private void sqlUserGrants(Connection connection, String schema, String username) throws SQLException {
        this.exeSql(connection, "grant create on schema " + schema + " to " + username);
    }

    private void sqlCreateSchema(Connection connection, String schema) throws SQLException {
        this.exeSql(connection, "create schema " + schema);
    }

    private void sqlCreateUser(Connection connection, String username, String password) throws SQLException {
        this.exeSql(connection, "create user " + username + " password '" + password + "'");
    }

    private boolean sqlSchemaExists(Connection connection, String schemaName) throws SQLException {
        return this.sqlQueryMatch(connection, "select schema from system.schemas", schemaName);
    }

    private boolean sqlUserExists(Connection connection, String dbUser) throws SQLException {
        return this.sqlQueryMatch(connection, "select username from system.users", dbUser);
    }

    private void exeSql(Connection connection, String sql) throws SQLException {
        log.debug("exeSql {}", (Object)sql);
        try (PreparedStatement st = connection.prepareStatement(sql);){
            st.execute();
        }
    }

    public static class Builder
    extends DbConfig<NuoDBContainer, Builder> {
        private String network = "nuodb-net";
        private String sm1 = "sm";
        private String te1 = "te";
        private String labels = "node localhost";
        private int port2 = 48004;
        private int internalPort2 = 48004;
        private int port3 = 48005;
        private int internalPort3 = 48005;

        private Builder(String version) {
            super("nuodb", 8888, 8888, version);
            this.containerName = this.platform;
            this.image = "nuodb/nuodb-ce:" + version;
            this.adminUsername = "dba";
            this.adminPassword = "dba";
            this.dbName = "testdb";
        }

        @Override
        protected String buildSummary() {
            return "host:" + this.host + " port:" + this.port + " db:" + this.dbName + " schema:" + this.schema + " user:" + this.deriveUsername() + "/" + this.password;
        }

        @Override
        protected String buildJdbcUrl() {
            return "jdbc:com.nuodb://" + this.getHost() + "/" + this.getDbName();
        }

        public Builder port2(int port2) {
            this.port2 = port2;
            return (Builder)this.self();
        }

        public Builder internalPort2(int internalPort2) {
            this.internalPort2 = internalPort2;
            return (Builder)this.self();
        }

        public Builder port3(int port3) {
            this.port3 = port3;
            return (Builder)this.self();
        }

        public Builder internalPort3(int internalPort3) {
            this.internalPort3 = internalPort3;
            return (Builder)this.self();
        }

        public Builder network(String network) {
            this.network = network;
            return (Builder)this.self();
        }

        public Builder sm1(String sm1) {
            this.sm1 = sm1;
            return (Builder)this.self();
        }

        public Builder te1(String te1) {
            this.te1 = te1;
            return (Builder)this.self();
        }

        public Builder labels(String labels) {
            this.labels = labels;
            return (Builder)this.self();
        }

        private String getSm1() {
            return this.sm1;
        }

        private String getTe1() {
            return this.te1;
        }

        private String getLabels() {
            return this.labels;
        }

        private int getPort2() {
            return this.port2;
        }

        private int getInternalPort2() {
            return this.internalPort2;
        }

        private int getPort3() {
            return this.port3;
        }

        private int getInternalPort3() {
            return this.internalPort3;
        }

        private String getNetwork() {
            return this.network;
        }

        @Override
        public NuoDBContainer build() {
            return new NuoDBContainer(this);
        }
    }
}

