/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.docker.commands;

import io.ebean.docker.commands.DbConfig;
import io.ebean.docker.commands.JdbcBaseDbContainer;
import io.ebean.docker.container.Container;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class OracleContainer
extends JdbcBaseDbContainer
implements Container {
    private final Builder oracleConfig;
    private boolean oracleScript;

    public static Builder newBuilder(String version) {
        return new Builder(version);
    }

    public OracleContainer(Builder builder) {
        super(builder);
        this.oracleConfig = builder;
        this.checkConnectivityUsingAdmin = true;
        this.waitForConnectivityAttempts = 2000;
    }

    @Override
    void createDatabase() {
        this.createRoleAndDatabase(false);
    }

    @Override
    void dropCreateDatabase() {
        this.createRoleAndDatabase(true);
    }

    private void createRoleAndDatabase(boolean withDrop) {
        try (Connection connection = this.config.createAdminConnection();){
            if (withDrop) {
                this.dropUser(connection);
            }
            this.createUser(connection, withDrop);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error when creating database and role", e);
        }
    }

    private void sqlRunOracleScript(Connection connection) {
        if (!this.oracleScript) {
            this.sqlRun(connection, "alter session set \"_ORACLE_SCRIPT\"=true");
            this.oracleScript = true;
        }
    }

    private void dropUser(Connection connection) {
        if (this.userExists(connection)) {
            this.sqlRunOracleScript(connection);
            this.sqlRun(connection, "drop user " + this.dbConfig.getUsername() + " cascade");
        }
    }

    private void createUser(Connection connection, boolean withDrop) {
        if (withDrop || !this.userExists(connection)) {
            this.sqlRunOracleScript(connection);
            this.sqlRun(connection, "create user " + this.dbConfig.getUsername() + " identified by " + this.dbConfig.getPassword());
            this.sqlRun(connection, "grant connect, resource,  create view, unlimited tablespace to " + this.dbConfig.getUsername());
        }
    }

    private boolean userExists(Connection connection) {
        String sql = "select 1 from dba_users where lower(username) = '" + this.dbConfig.getUsername().toLowerCase() + "'";
        return this.sqlHasRow(connection, sql);
    }

    @Override
    protected ProcessBuilder runProcess() {
        List<String> args = this.dockerRun();
        args.add("-p");
        args.add(this.oracleConfig.getApexPort() + ":" + this.oracleConfig.getInternalApexPort());
        args.add("-e");
        args.add("ORACLE_PWD=" + this.dbConfig.getAdminPassword());
        args.add(this.config.getImage());
        return this.createProcessBuilder(args);
    }

    public static class Builder
    extends DbConfig<OracleContainer, Builder> {
        private String apexPort = "8181";
        private String internalApexPort = "8080";
        private int startupWaitMinutes = 8;

        private Builder(String version) {
            super("oracle", 1521, 1521, version);
            this.image = "vitorfec/oracle-xe-18c:" + version;
            this.adminUsername = "system";
            this.adminPassword = "oracle";
            this.dbName = "XE";
            this.username = "test_user";
        }

        @Override
        protected String buildJdbcUrl() {
            return "jdbc:oracle:thin:@" + this.getHost() + ":" + this.getPort() + ":" + this.getDbName();
        }

        @Override
        public Builder dbName(String dbName) {
            return (Builder)super.dbName(dbName);
        }

        @Override
        public Builder user(String user) {
            return (Builder)super.user(user);
        }

        public Builder apexPort(String apexPort) {
            this.apexPort = apexPort;
            return (Builder)this.self();
        }

        public Builder internalApexPort(String internalApexPort) {
            this.internalApexPort = internalApexPort;
            return (Builder)this.self();
        }

        public Builder startupWaitMinutes(int startupWaitMinutes) {
            this.startupWaitMinutes = startupWaitMinutes;
            return (Builder)this.self();
        }

        private String getApexPort() {
            return this.apexPort;
        }

        private String getInternalApexPort() {
            return this.internalApexPort;
        }

        private int getStartupWaitMinutes() {
            return this.startupWaitMinutes;
        }

        @Override
        public OracleContainer build() {
            return new OracleContainer(this);
        }
    }
}

