/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.docker.commands;

import io.ebean.docker.commands.BasePostgresContainer;
import io.ebean.docker.commands.DbConfig;
import io.ebean.docker.container.Container;
import io.ebean.docker.container.StopMode;

public class PostgresContainer
extends BasePostgresContainer
implements Container {
    public static Builder newBuilder(String version) {
        return new Builder(version);
    }

    private PostgresContainer(Builder config) {
        super((DbConfig)config);
    }

    public static class Builder
    extends DbConfig<PostgresContainer, Builder> {
        private Builder(String version) {
            super("postgres", 6432, 5432, version);
            this.adminUsername = "postgres";
            this.stopMode(StopMode.Remove);
            this.tmpfs("/var/lib/postgresql/data:rw");
        }

        @Override
        protected String buildJdbcUrl() {
            return "jdbc:postgresql://" + this.host + ":" + this.port + "/" + this.dbName;
        }

        @Override
        protected String buildJdbcAdminUrl() {
            return "jdbc:postgresql://" + this.host + ":" + this.port + "/postgres";
        }

        @Override
        public PostgresContainer build() {
            return new PostgresContainer(this);
        }
    }
}

