/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.docker.container;

import io.ebean.docker.commands.ClickHouseContainer;
import io.ebean.docker.commands.CockroachContainer;
import io.ebean.docker.commands.Db2Container;
import io.ebean.docker.commands.ElasticContainer;
import io.ebean.docker.commands.HanaContainer;
import io.ebean.docker.commands.MariaDBContainer;
import io.ebean.docker.commands.MySqlContainer;
import io.ebean.docker.commands.NuoDBContainer;
import io.ebean.docker.commands.OracleContainer;
import io.ebean.docker.commands.PostgresContainer;
import io.ebean.docker.commands.RedisContainer;
import io.ebean.docker.commands.SqlServerContainer;
import io.ebean.docker.commands.YugabyteContainer;
import io.ebean.docker.container.Container;
import io.ebean.docker.container.ContainerConfig;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;

public class ContainerFactory {
    private final Properties properties;
    private final List<Container> containers = new ArrayList<Container>();
    private final Set<String> runWith = new HashSet<String>();

    private static String defaultRunWith() {
        String runWith = System.getenv("DOCKER_RUN_WITH");
        return System.getProperty("docker_run_with", runWith);
    }

    public ContainerFactory(Properties properties) {
        this(properties, ContainerFactory.defaultRunWith());
    }

    public ContainerFactory(Properties properties, String runWith) {
        this.properties = properties;
        this.initRunWith(runWith);
        this.init();
    }

    private void initRunWith(String runWithOptions) {
        if (runWithOptions != null) {
            for (String value : runWithOptions.split(",")) {
                this.runWith.add(value.trim().toLowerCase());
            }
        }
    }

    private void init() {
        String db2Version;
        String yugaVersion;
        String cockroachVersion;
        String clickhouseVersion;
        String hanaVersion;
        String oracleVersion;
        String sqlServerVersion;
        String nuodbVersion;
        String mariadbVersion;
        String mysqlVersion;
        String pgVersion;
        String redisVersion;
        String elasticVersion = this.version("elastic");
        if (elasticVersion != null) {
            this.containers.add(((ElasticContainer.Builder)ElasticContainer.newBuilder(elasticVersion).properties(this.properties)).build());
        }
        if ((redisVersion = this.version("redis")) != null) {
            this.containers.add(((RedisContainer.Builder)RedisContainer.newBuilder(redisVersion).properties(this.properties)).build());
        }
        if ((pgVersion = this.runWithVersion("postgres")) != null) {
            this.containers.add(((PostgresContainer.Builder)PostgresContainer.newBuilder(pgVersion).properties(this.properties)).build());
        }
        if ((mysqlVersion = this.runWithVersion("mysql")) != null) {
            this.containers.add(((MySqlContainer.Builder)MySqlContainer.newBuilder(mysqlVersion).properties(this.properties)).build());
        }
        if ((mariadbVersion = this.runWithVersion("mariadb")) != null) {
            this.containers.add(((MariaDBContainer.Builder)MariaDBContainer.newBuilder(mariadbVersion).properties(this.properties)).build());
        }
        if ((nuodbVersion = this.runWithVersion("nuodb")) != null) {
            this.containers.add(((NuoDBContainer.Builder)NuoDBContainer.newBuilder(nuodbVersion).properties(this.properties)).build());
        }
        if ((sqlServerVersion = this.runWithVersion("sqlserver")) != null) {
            this.containers.add(((SqlServerContainer.Builder)SqlServerContainer.newBuilder(sqlServerVersion).properties(this.properties)).build());
        }
        if ((oracleVersion = this.runWithVersion("oracle")) != null) {
            this.containers.add(((OracleContainer.Builder)OracleContainer.newBuilder(oracleVersion).properties(this.properties)).build());
        }
        if ((hanaVersion = this.runWithVersion("hana")) != null) {
            this.containers.add(((HanaContainer.Builder)HanaContainer.newBuilder(hanaVersion).properties(this.properties)).build());
        }
        if ((clickhouseVersion = this.runWithVersion("clickhouse")) != null) {
            this.containers.add(((ClickHouseContainer.Builder)ClickHouseContainer.newBuilder(clickhouseVersion).properties(this.properties)).build());
        }
        if ((cockroachVersion = this.runWithVersion("cockroach")) != null) {
            this.containers.add(((CockroachContainer.Builder)CockroachContainer.newBuilder(cockroachVersion).properties(this.properties)).build());
        }
        if ((yugaVersion = this.runWithVersion("yugabyte")) != null) {
            this.containers.add(((YugabyteContainer.Builder)YugabyteContainer.newBuilder(yugaVersion).properties(this.properties)).build());
        }
        if ((db2Version = this.runWithVersion("db2")) != null) {
            this.containers.add(((Db2Container.Builder)Db2Container.newBuilder(db2Version).properties(this.properties)).build());
        }
    }

    String runWithVersion(String name) {
        String version = this.version(name);
        if (version == null) {
            return null;
        }
        return this.runWith.isEmpty() || this.runWith.contains(name) ? version : null;
    }

    private String version(String prefix) {
        return this.properties.getProperty(prefix + ".version");
    }

    public void startContainers() {
        this.startContainers(null);
    }

    public void startContainers(Consumer<String> logging) {
        for (Container container : this.containers) {
            if (logging != null) {
                logging.accept(container.config().startDescription());
            }
            container.start();
        }
    }

    public void stopContainers() {
        this.stopContainers(null);
    }

    public void stopContainers(Consumer<String> logging) {
        for (Container container : this.containers) {
            if (logging != null) {
                logging.accept(container.config().stopDescription());
            }
            container.stop();
        }
    }

    public void stopOnly() {
        this.stopOnly(null);
    }

    public void stopOnly(Consumer<String> logging) {
        for (Container container : this.containers) {
            if (logging != null) {
                logging.accept(container.config().stopDescription());
            }
            container.stopOnly();
        }
    }

    public ContainerConfig config(String platform) {
        Container container = this.container(platform);
        return container == null ? null : container.config();
    }

    public Container container(String platform) {
        for (Container container : this.containers) {
            ContainerConfig config = container.config();
            if (!config.platform().equalsIgnoreCase(platform)) continue;
            return container;
        }
        return null;
    }
}

