/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.test.config;

import io.ebean.config.AutoConfigure;
import io.ebean.config.DatabaseConfig;
import io.ebean.datasource.DataSourceConfig;
import io.ebean.test.config.RunOnceMarker;
import io.ebean.test.config.platform.PlatformAutoConfig;
import io.ebean.test.config.provider.ProviderAutoConfig;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoConfigureForTesting
implements AutoConfigure {
    private static final Logger log = LoggerFactory.getLogger((String)"io.ebean.test");
    private final String environmentDb = System.getProperty("db");

    public void preConfigure(DatabaseConfig config) {
        Properties properties = config.getProperties();
        if (this.isExtraServer(config, properties)) {
            this.setupExtraDataSourceIfNecessary(config);
            return;
        }
        String testPlatform = properties.getProperty("ebean.test.platform");
        log.debug("automatic testing config - with ebean.test.platform:{} environment db:{} name:{}", new Object[]{testPlatform, this.environmentDb, config.getName()});
        if (RunOnceMarker.isRun()) {
            this.setupPlatform(this.environmentDb, config);
        }
    }

    public void postConfigure(DatabaseConfig config) {
        this.setupProviders(config);
    }

    private void makeV1Compatible(DataSourceConfig ds) {
        if (ds == null) {
            return;
        }
        String url = ds.getUrl();
        if (url == null || !url.startsWith("jdbc:h2:")) {
            return;
        }
        url = url.replace(";MODE=LEGACY", "");
        url = url.replace(";NON_KEYWORDS=KEY,VALUE", "");
        url = url.replace(";NON_KEYWORDS=KEY", "");
        ds.setUrl(url);
    }

    private boolean isExtraServer(DatabaseConfig config, Properties properties) {
        String extraDb = properties.getProperty("ebean.test.extraDb.dbName", properties.getProperty("ebean.test.extraDb"));
        if (extraDb != null && extraDb.equals(config.getName())) {
            config.setDefaultServer(false);
            return true;
        }
        return false;
    }

    private void setupExtraDataSourceIfNecessary(DatabaseConfig config) {
        DataSourceConfig dataSourceConfig = config.getDataSourceConfig();
        if (dataSourceConfig == null || dataSourceConfig.getUsername() == null) {
            new PlatformAutoConfig(this.environmentDb, config).configExtraDataSource();
        }
    }

    private void setupProviders(DatabaseConfig config) {
        new ProviderAutoConfig(config).run();
    }

    private void setupPlatform(String db, DatabaseConfig config) {
        new PlatformAutoConfig(db, config).run();
    }
}

