/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.test.config.platform;

import java.io.File;
import java.util.Locale;

class DockerHost {
    private final boolean runningInDocker = this.initInDocker();
    private String dockerHost;

    DockerHost() {
    }

    boolean runningInDocker() {
        return this.runningInDocker;
    }

    String dockerHost() {
        return this.dockerHost;
    }

    String dockerHost(String explicitHost) {
        if (!this.runningInDocker) {
            return "localhost";
        }
        this.dockerHost = explicitHost != null ? explicitHost : this.defaultDockerHost();
        return this.dockerHost;
    }

    boolean initInDocker() {
        return new File("/.dockerenv").exists();
    }

    String defaultDockerHost() {
        String os = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
        if (os.contains("mac") || os.contains("darwin") || os.contains("win")) {
            return "host.docker.internal";
        }
        return "172.17.0.1";
    }
}

