/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.test;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

class IOUtils {
    IOUtils() {
    }

    static String readResource(String resourcePath) {
        try {
            InputStream is = IOUtils.class.getResourceAsStream(resourcePath);
            return IOUtils.readUtf8(is).trim();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error reading resource " + resourcePath, e);
        }
    }

    static String readUtf8(InputStream in) throws IOException {
        return IOUtils.bytesToUtf8(IOUtils.read(in));
    }

    private static byte[] read(InputStream in) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        IOUtils.pump(in, buffer);
        return buffer.toByteArray();
    }

    private static String bytesToUtf8(byte[] data) {
        return new String(data, StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void pump(InputStream in, OutputStream out) throws IOException {
        if (in == null) {
            throw new IOException("Input stream is null");
        }
        if (out == null) {
            throw new IOException("Output stream is null");
        }
        try {
            try {
                int bytes;
                byte[] buffer = new byte[4096];
                while ((bytes = in.read(buffer)) >= 0) {
                    out.write(buffer, 0, bytes);
                }
            }
            finally {
                in.close();
            }
        }
        finally {
            out.close();
        }
    }
}

